
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function hjszzlTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('zjny.xlsx', '环境数字治理');

    let keyValueOrTitleList = ["天气检测","土壤检测","水质检测","环境基础分析","治理情况","灾害性应急管理", "病害虫治理", "虫害检测灯预警", "气象灾害列表"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["气温趋势","土壤微量元素监测","浊度趋势变化","温度趋势变化","PH值趋势变化",,"NH3-N趋势变化","溶解氧趋势变化","虫害治理成效"]; //适配 柱状图 折线图 //
    let stringList = [];
    let decollatePlanarList =["天气检测表"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}