
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function gfnyTableData() {
    
    // let blockDataList = onceSheetBecomeOfblockData('zjnt.xlsx', '光伏能源');

    // let keyValueOrTitleList = ["基本情况","能耗分析","投入使用","光伏能源","效益分析","效益分析","节能减排"];//适配 饼图 键值以及需要多个key的
    // let barChartList = ["发电功率平均值分析","发电功率最大值分析","投入使用趋势","发电量趋势","累计减排统计"]; //适配 柱状图 折线图 
    // let stringList = [];
    // let decollatePlanarList =[];//适配 表格
    // let titltListConfig = {};

    // let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    // return result;

        
}