
import { yzdqxdnyzlTableData } from '../data/table/yzdqxdnyzlData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            “一轴多区”现代农业走廊                    */

export function getData(req, res) {
    let excelData = yzdqxdnyzlTableData();

    let ret:any = {};
                    
    /**中上 */
    let ztsjfbPackageData = keyValuePackage(excelData['总体数据分布'].dataList);
    ret['ztsjfb'] = getKeyValueOut('总体数据分布', ztsjfbPackageData);
           
    /**左屏 */
    let zrzyPackageData = keyValuePackage(excelData['张江镇自然资源'].dataList);
    ret['zrzy'] = getKeyValueOut('张江镇自然资源', zrzyPackageData);
                    
    let szylylPackageData = keyValuePackage(excelData['水资源利用率'].dataList);
    ret['szylyl'] = getKeyValueOut('水资源利用率', szylylPackageData);
                    
    let qyqkPackageData = keyValuePackage(excelData['企业情况'].dataList);
    ret['qyqk'] = getKeyValueOut('企业情况', qyqkPackageData);
                    
    let zyyglxPackageData = keyValuePackage(excelData['专业员工类型'].dataList);
    ret['zyyglx'] = getKeyValueOut('专业员工类型', zyyglxPackageData);
                    
    let cyryqkPackageData = keyValuePackage(excelData['从业人员情况'].dataList);
    ret['cyryqk'] = getKeyValueOut('从业人员情况', cyryqkPackageData);
                    
    let cyjgPackageData = keyValuePackage(excelData['产业结构'].dataList);
    ret['cyjg'] = getKeyValueOut('产业结构', cyjgPackageData);
                    
    let cyztjgPackageData = keyValuePackage(excelData['产业主体结构'].dataList);
    ret['cyztjg'] = getKeyValueOut('产业主体结构', cyztjgPackageData);

    /**右屏 */
    let zdxmjsPackageData = keyValuePackage(excelData['重点项目建设'].dataList);
    ret['zdxmjs'] = getKeyValueOut('重点项目建设', zdxmjsPackageData);

    let xmfxPackageData = keyValuePackage(excelData['项目分析'].dataList);
    ret['xmfx'] = getKeyValueOut('项目分析', xmfxPackageData);
                    
    let zjfwPackageData = keyValuePackage(excelData['专家服务'].dataList);
    ret['zjfw'] = getKeyValueOut('专家服务', zjfwPackageData);

    let jsyjqkPackageData = keyValuePackage(excelData['技术创新引进情况'].dataList);
    ret['jsyjqk'] = getKeyValueOut('技术创新引进情况', jsyjqkPackageData);
                    
    let cxjsjcsjPackageData = keyValuePackage(excelData['创新技术基础数据'].dataList);
    ret['cxjsjcsj'] = getKeyValueOut('创新技术基础数据', cxjsjcsjPackageData);

    let jscxqsPackageData = onceYBarChartPackage( excelData['技术创新趋势'], '','');
    ret['jscxqs'] = getOnceYBarChartOut('技术创新趋势', jscxqsPackageData);

    let yjjsyjqkPackageData = keyValuePackage(excelData['引进技术基础数据'].dataList);
    ret['yjjsyjqk'] = getKeyValueOut('引进技术基础数据', yjjsyjqkPackageData);
    
    let yjjscxqsPackageData = onceYBarChartPackage( excelData['引进技术创新趋势'], '','');
    ret['yjjscxqs'] = getOnceYBarChartOut('引进技术创新趋势', yjjscxqsPackageData);

    let jyglqkPackageData = keyValuePackage(excelData['经营管理情况'].dataList);
    ret['jyglqk'] = getKeyValueOut('经营管理情况', jyglqkPackageData);

    let jyglqkqstPackageData = onceYBarChartPackage( excelData['农业生产产值趋势图'], '','');
    ret['jyglqkqst'] = getOnceYBarChartOut('农业生产产值趋势图', jyglqkqstPackageData);
                     
    res.send(ret);
} 