
import { systemConfig } from '../config/serverConfig';
import { hjszzlTableData } from '../data/table/hjszzlData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, stringListPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getStringOut, getTableOut } from '../dataPackage/out';

/*                            环境数字治理                    */

export function getData(req, res) {
    let excelData = hjszzlTableData();

    let ret:any = {};

    let qwqsPackageData = onceYBarChartPackage( excelData['气温趋势'], '','');
    ret['qwqs'] = getOnceYBarChartOut('气温趋势', qwqsPackageData);
                    
    let trwlysjcPackageData = onceYBarChartPackage( excelData['土壤微量元素监测'], '','');
    ret['trwlysjc'] = getOnceYBarChartOut('土壤微量元素监测', trwlysjcPackageData);
                    
    let zdqsbhPackageData = onceYBarChartPackage( excelData['浊度趋势变化'], '','');
    ret['zdqsbh'] = getOnceYBarChartOut('浊度趋势变化', zdqsbhPackageData);

    // let wdbhqsPackageData = onceYBarChartPackage( excelData['温度趋势变化'], '','');
    // ret['zdqswdbhqsbh'] = getOnceYBarChartOut('温度趋势变化', wdbhqsPackageData);

    // let PHzqsbhPackageData = onceYBarChartPackage( excelData['PH值趋势变化'], '','');
    // ret['PHzqsbh'] = getOnceYBarChartOut('浊度趋势变化', PHzqsbhPackageData);

    // let NH3NqsbhPackageData = onceYBarChartPackage( excelData['NH3-N趋势变化'], '','');
    // ret['NH3Nqsbh'] = getOnceYBarChartOut('NH3-N趋势变化', NH3NqsbhPackageData);

    // let rjyqsbhPackageData = onceYBarChartPackage( excelData['溶解氧趋势变化'], '','');
    // ret['rjyqsbh'] = getOnceYBarChartOut('溶解氧趋势变化', rjyqsbhPackageData);
                    
    let chzlcxPackageData = onceYBarChartPackage( excelData['虫害治理成效'], '','');
    ret['chzlcx'] = getOnceYBarChartOut('虫害治理成效', chzlcxPackageData);
                    
    let tqjcPackageData = keyValuePackage(excelData['天气检测'].dataList);
    ret['tqjc'] = getKeyValueOut('天气检测', tqjcPackageData);
                    
    let trjcPackageData = keyValuePackage(excelData['土壤检测'].dataList);
    ret['trjc'] = getKeyValueOut('土壤检测', trjcPackageData);
                    
    let szjcPackageData = keyValuePackage(excelData['水质检测'].dataList);
    ret['szjc'] = getKeyValueOut('水质检测', szjcPackageData);
                    
    let hjjcfxPackageData = keyValuePackage(excelData['环境基础分析'].dataList);
    ret['hjjcfx'] = getKeyValueOut('环境基础分析', hjjcfxPackageData);
                    
    let bhczlPackageData = stringListPackage(excelData["病害虫治理"].dataList);
    let bhczl = [];
    for(let i = 0; i < bhczlPackageData.length; i++) {
        let img = `${systemConfig.imgPath}/${bhczlPackageData[i]}`;
        bhczl.push(img);
    }
    ret['bhczl'] = getStringOut('病害虫治理', bhczlPackageData);

    let chjcdyjPackageData = keyValuePackage(excelData['虫害检测灯预警'].dataList);
    ret['chjcdyj'] = getKeyValueOut('虫害检测灯预警', chjcdyjPackageData);

    let zlqkPackageData = keyValuePackage(excelData['治理情况'].dataList);
    ret['zlqk'] = getKeyValueOut('治理情况', zlqkPackageData);
                    
    let tqjcbTableData = tablePackage(excelData["天气检测表"].headerList[0], excelData["天气检测表"].bodyList);
    ret['tqjcb'] = getTableOut( '天气检测表', tqjcbTableData);
                    
    let zhxyjglPackageData = keyValuePackage(excelData['灾害性应急管理'].dataList);
    ret['zhxyjgl'] = getKeyValueOut('灾害性应急管理', zhxyjglPackageData);
                    
    let qxzhlbPackageData = keyValuePackage(excelData['气象灾害列表'].dataList);
    ret['qxzhlb'] = getKeyValueOut('气象灾害列表', qxzhlbPackageData);
                     
    res.send(ret);
} 