
import { gbzscbgjdAqTableData } from '../data/table/gbzscbgjdAq';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';
import { systemConfig } from "../config/serverConfig";

/*                            A区                    */

export function getData(req, res) {
    let excelData = gbzscbgjdAqTableData();

    let ret:any = {};
                    
    let AqjdxqPackageData = keyValuePackage(excelData['A区基地详情'].dataList);
    ret['Aqjdxq'] = getKeyValueOut('A区基地详情', AqjdxqPackageData);

    let jdfxPackageData = keyValuePackage(excelData['基地分析'].dataList);
    ret['jdfx'] = getKeyValueOut('基地分析', jdfxPackageData);
                    
    let zzzwpzTableData = tablePackage(excelData["种植作物品种"].headerList[0], excelData["种植作物品种"].bodyList);
    zzzwpzTableData.titleList.push("图片地址");
    let zzzwpz = {dataList:[], titleList:zzzwpzTableData.titleList};
    zzzwpzTableData.dataList.forEach(info => {
        let {A} = info;
        let imgUrl = `${systemConfig.imgPath}/蔬菜保供基地/${A}.png`;
        info["F"] = imgUrl;
        zzzwpz.dataList.push(info);
    })
    ret['zzzwpz'] = getTableOut( '种植作物品种', zzzwpz);

    let yclzzclqkPackageData = onceYBarChartPackage(excelData['叶菜类种植产量情况'], '', '');
    ret['yclzzclqk'] = getOnceYBarChartOut('叶菜类种植产量情况', yclzzclqkPackageData);

    let qglzzclqkPackageData = onceYBarChartPackage(excelData['茄果类种植产量情况'], '', '');
    ret['qglzzclqk'] = getOnceYBarChartOut('茄果类种植产量情况', qglzzclqkPackageData);
                    
    let cpsyPackageData = keyValuePackage(excelData['产品溯源'].dataList);
    ret['cpsy'] = getKeyValueOut('产品溯源', cpsyPackageData);

    let cpfxzbPackageData = keyValuePackage(excelData['产品销售情况占比'].dataList);
    ret['cpfxzb'] = getKeyValueOut('产品销售情况占比', cpfxzbPackageData);
                 
    res.send(ret);
} 