
import { systemConfig } from '../config/serverConfig';
import { cyszhglTableData } from '../data/table/cyszhglData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            产业数字化管理                    */

export function getData(req, res) {
    let excelData = cyszhglTableData();

    let ret:any = {};

    let sfjdglPackageData = keyValuePackage(excelData['示范基地概览'].dataList);
    ret['sfjdgl'] = getKeyValueOut('示范基地概览', sfjdglPackageData);

    let rzqyqkTableData = tablePackage(excelData["入驻企业情况"].headerList[0], excelData["入驻企业情况"].bodyList);
    ret['rzqyqk'] = getTableOut( '入驻企业情况', rzqyqkTableData);

    let sfdtrpsyjlPackageData = keyValuePackage(excelData['示范地投入品使用记录'].dataList);
    ret['sfdtrpsyjl'] = getKeyValueOut('示范地投入品使用记录', sfdtrpsyjlPackageData);

    let trpsyqkPackageData = onceYBarChartPackage( excelData['投入品使用情况'], '','');
    ret['trpsyqk'] = getOnceYBarChartOut('投入品使用情况', trpsyqkPackageData);

    let lsfkwzsyqkPackageData = doubleYBarCharPackage( excelData['绿色防控物资使用情况'], "亩次", '使用量','亩次');
    ret['lsfkwzsyqk'] = getDoubleYBarChartOut('绿色防控物资使用情况', lsfkwzsyqkPackageData);

    let fxyjPackageData = keyValuePackage(excelData['风险预警'].dataList);
    ret['fxyj'] = getKeyValueOut('风险预警', fxyjPackageData);

    let fxlxzbPackageData = keyValuePackage(excelData['风险类型占比'].dataList);
    ret['fxlxzb'] = getKeyValueOut('风险类型占比', fxlxzbPackageData);

    let yjxqgdTableData = tablePackage(excelData["预警详情工单"].headerList[0], excelData["预警详情工单"].bodyList);
    ret['yjxqgd'] = getTableOut( '预警详情工单', yjxqgdTableData);

    let znggfxPackageData = keyValuePackage(excelData['智能灌溉分析'].dataList);
    ret['znggfx'] = getKeyValueOut('智能灌溉分析', znggfxPackageData);

    let gglqsfxPackageData = onceYBarChartPackage( excelData['灌溉量趋势分析'], '','');
    ret['gglqsfx'] = getOnceYBarChartOut('灌溉量趋势分析', gglqsfxPackageData);

    let scxyfxPackageData = onceYBarChartPackage(excelData['蔬菜效益分析'],  '日统计', '' );
    ret['scxyfx'] = getOnceYBarChartOut('蔬菜效益分析', scxyfxPackageData);

    let yyxyfxPackageData = onceYBarChartPackage(excelData['渔业效益分析'], '日统计', '' );
    ret['yyxyfx'] = getOnceYBarChartOut('渔业效益分析', yyxyfxPackageData);
    
    let xyfxPackageData = onceYBarChartPackage(excelData['效益分析'], '元', '' );
    ret['xyfx'] = getOnceYBarChartOut('效益分析', xyfxPackageData);
    
    let cyxlphPackageData = keyValuePackage(excelData['产业销量排行'].dataList);
    ret['cyxlph'] = getKeyValueOut('产业销量排行', cyxlphPackageData);

    let cpsyxxTableData = tablePackage(excelData["产品溯源信息"].headerList[0], excelData["产品溯源信息"].bodyList);
    ret['cpsyxx'] = getTableOut( '产品溯源信息', cpsyxxTableData);

    let aqglTableData = keyValuePackage(excelData["安全管理"].dataList);
    ret['aqgl'] = getKeyValueOut( '安全管理', aqglTableData);

    let ncpaqzljcPackageData = onceYBarChartPackage(excelData['农产品安全质量检测'], '日统计', '' );
    ret['ncpaqzljc'] = getOnceYBarChartOut('农产品安全质量检测', ncpaqzljcPackageData);

                    
    let szcyPackageData = keyValuePackage(excelData['数字产业'].dataList);
    let szhglPackageData = keyValuePackage(excelData['数字化管理'].dataList);
    ret['szcy'] = getKeyValueOut('数字产业', szcyPackageData.concat(szhglPackageData));

    let znggTableData = {};
    excelData["智能灌溉"].dataList.forEach( info => {
        let {ntwz, trsd, ggsj, ggjgsj, sfxygg} = info;
        info["img"] = `${systemConfig.imgPath}/监控/${ntwz}.png`;
        znggTableData[ntwz] = info;
    })

    ret['zngg'] = {title:'智能灌溉', dataList:znggTableData};
                     
    res.send(ret);
}

/**
 * 种植种类/种植分布
 */
export async function zzzl(req, res) {
    let {type} = req.body;
    let excelData = cyszhglTableData();
    let ret:any = {};

    let config = {
        "叶菜类":{
            "菠菜":1, "芹菜":1, "油菜（青菜）":1, "大白菜":1, "黄瓜":1, "白萝卜":1, "胡萝卜":1, "土豆":1
        },
        "茄果类":{
            "茄子":1, "西红柿":1, "青椒（甜椒）":1, "辣椒":1
        },
        "花卉类":{
            "多肉植物":1, "蝴蝶兰":1, "仙客来":1, "绣球":1, "四季草花":1, "幸福树":1, "发财树":1
        }
    }
    let zzzlAllTableData:any = tablePackage(excelData["种植种类"].headerList[0], excelData["种植种类"].bodyList);
    // ret['zzzl'] = getTableOut( '种植种类', zzzlTableData);
    let keyMap = config[type] || {};
    let zzzlTableDataList = [];
    zzzlAllTableData.valueList.forEach(subList => {
        let name = subList[0]
        if (keyMap[name]) {
            zzzlTableDataList.push({
                key:name,
                value:subList[1] || "0株",
                rate:subList[2] || "0%"
            });
        }
    });

    ret["zzzl"] = zzzlTableDataList;

    res.send(ret);  
}