/**
 * 机器人
 */

import { jiQiRenTableData } from "../data/table/tableData";
import { keyValuePackage, onceYBarChartPackage, tablePackage } from "../dataPackage/inFrontOut";
import { getKeyValueOut, getOnceYBarChartOut, getTableOut } from "../dataPackage/out";


/**
 * 左屏
 * @param req 
 * @param res 
 */
export async function getLeft(req, res) {
    let ret:any = {};
    let data = jiQiRenTableData();


    ret['jqrlxzb'] = getKeyValueOut('机器人类型占比', data["机器人类型占比"].dataList);
    ret['yxzt'] = getKeyValueOut('运行状态', data["运行状态"].dataList);

    let yxqsfx = onceYBarChartPackage(data["运行趋势分析"], '');
    ret['yxqsfx'] = getOnceYBarChartOut('运行趋势分析', yxqsfx);

    let yxjl = tablePackage(data["运行记录"].headerList[0], data["运行记录"].bodyList);
    ret['yxjl'] = getTableOut('运行记录', yxjl);

    let qybj = onceYBarChartPackage(data["区域布局"], '');
    ret['qybj'] = getOnceYBarChartOut('区域布局', qybj);

    res.send(ret);
}



/**
 * 右屏
 * @param req 
 * @param res 
 */
export async function getRight(req, res) {
    let ret:any = {};
    let data = jiQiRenTableData();

    let xjsblx = onceYBarChartPackage(data["巡检设备类型"], '');
    ret['xjsblx'] = getOnceYBarChartOut('巡检设备类型', xjsblx);

    let xjqs = onceYBarChartPackage(data["巡检趋势"], '');
    ret['xjqs'] = getOnceYBarChartOut('巡检趋势', xjqs);

    let xjjl =  tablePackage(data["巡检记录"].headerList[0], data["巡检记录"].bodyList);
    ret['xjjl'] = getTableOut('巡检记录', xjjl);

    let znjqrcl = onceYBarChartPackage(data["智能机器人产量"], '');
    ret['znjqrcl'] = getOnceYBarChartOut('智能机器人产量', znjqrcl);

    res.send(ret);
}


export async function getTop(req, res) {
    let ret:any = {};
    let data = jiQiRenTableData();

    let jcxx = keyValuePackage(data["顶部指标"].dataList);
    ret['jcxx'] = getKeyValueOut('顶部指标', jcxx);

    res.send(ret);
}