
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function nyjqrTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('zjny.xlsx', '农业机器人');

    let keyValueOrTitleList = ["机器人类型占比","机器人资源","运行状态","农业机器人数据","智能巡检","巡检完成情况","智能机器人产量","机器人类型占比","机器人数据分析"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["运势趋势分析","区域分布","巡检设备类型","巡检趋势","近半年产量趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["运行记录","巡检记录"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}