
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function cyszhglTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('zjny.xlsx', '产业数字化管理');

    // let keyValueOrTitleList = ["智能灌溉","风险类型占比","示范基地概览","示范地投入品使用记录","风险预警","产业销量排行","数字产业"];//适配 饼图 键值以及需要多个key的
    // let barChartList = ["苗情检测","种子投入品使用趋势分析","种苗投入品使用趋势分析","肥料投入品使用趋势分析","农药投入品使用趋势分析",
    //     "蔬菜效益分析","渔业效益分析","灌溉量趋势分析"]; //适配 柱状图 折线图 
    // let stringList = [];
    // let decollatePlanarList =["预警详情工单","种植种类", "种植分布","产品溯源信息"];//适配 表格
    // let titltListConfig = {};

    let keyValueOrTitleList = ["风险类型占比", "安全管理","示范基地概览","示范地投入品使用记录","风险预警","产业销量排行","数字产业", "数字化管理", "智能灌溉", "智能灌溉分析"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["苗情检测","农产品安全质量检测","蔬菜效益分析","渔业效益分析","灌溉量趋势分析", "投入品使用情况", "绿色防控物资使用情况", "溉量趋势分析", "效益分析"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["入驻企业情况", "预警详情工单","种植种类", "种植分布","产品溯源信息"];//适配 表格
    let titltListConfig = {};


    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}