const path = require('path');
import * as fs from "fs";
import { BizError, SysError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { ServerConfig } from "./systemClass";
import { SYSTEMERRORENUM } from "./errorEnum";

export let systemConfig = new ServerConfig;

const ConfigName = "serverConfig.xml";

export let dataCenterInterfaceConfig = {
    hqmdzsjgl:"", //获取某电站数据概览
    // hqsyyhdz: "", //获取所有用户电站列表
    hqmgyhddzlb: "", //获取某个用户的电站列表
    hqmdzlsfdl: "", //获取某电站历史发电量
    hqmdzmytgl: "", //获取某电站某一天功率数据
    hqmdzjbxx: "", //获取某电站基本信息
}



export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) console.log("xml中无配置加载");
		else {
            //必要配置
            let integralConfig = ["port", "token", "userName", "plantId", 
                {"dataCenterInterface":["hqmdzsjgl", "hqsyyhdz", "hqmgyhddzlb", "hqmdzlsfdl", "hqmdzmytgl", "hqmdzjbxx"]}
            ];
            
            checkConfig(integralConfig, configInfo.config);

			let {port, imgPath, token, userName, plantId, dataCenterInterface} = configInfo.config;

			systemConfig.port = parseInt(port[0]);
            systemConfig.imgPath = imgPath[0];
			systemConfig.token = token[0];
			systemConfig.userName = userName[0];
            systemConfig.plantId = parseInt(plantId[0]);
            //API数据接口
            dataCenterInterfaceConfig.hqmdzsjgl = dataCenterInterface[0].hqmdzsjgl[0];
            // dataCenterInterfaceConfig.hqsyyhdz = dataCenterInterface[0].hqsyyhdz[0];
            dataCenterInterfaceConfig.hqmgyhddzlb = dataCenterInterface[0].hqmgyhddzlb[0];
            dataCenterInterfaceConfig.hqmdzlsfdl = dataCenterInterface[0].hqmdzlsfdl[0];
            dataCenterInterfaceConfig.hqmdzmytgl = dataCenterInterface[0].hqmdzmytgl[0];
            dataCenterInterfaceConfig.hqmdzjbxx = dataCenterInterface[0].hqmdzjbxx[0];
            // console.log(dataCenterInterfaceConfig.hqmdzsjgl);
		}

    } catch(err) {
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
 

function checkConfig(config, configData) {
    config.forEach(item => {
        if (typeof item == "object") {
            for (let key in item) {
                if (!configData[key] || !configData[key][0]) {
                    throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 缺少 ${key}`);
                }
                item[key].forEach( subItem => {
                    if (!configData[key][0][subItem] || !configData[key][0][subItem][0]) {
                        throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 ${key}缺少 ${subItem}`);
                    }
                });

            }
        } else {
            if (!configData[item] || !configData[item][0]) {
                throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 缺少 ${item}`);
            }
        }
    });
}

