
import { nyjqrTableData } from '../data/table/nyjqrData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            农业机器人                    */

export function getData(req, res) {
    let excelData = nyjqrTableData();

    let ret:any = {};

    let ysqsfxPackageData = onceYBarChartPackage( excelData['运势趋势分析'], '时长','');
    ret['ysqsfx'] = getOnceYBarChartOut('运势趋势分析', ysqsfxPackageData);
                    
    let qyfbPackageData = onceYBarChartPackage( excelData['区域分布'], '','台套');
    ret['qyfb'] = getOnceYBarChartOut('区域分布', qyfbPackageData);
                    
    let nyjqrsjPackageData = keyValuePackage(excelData['农业机器人数据'].dataList);
    ret['nyjqrsj'] = getKeyValueOut('农业机器人数据', nyjqrsjPackageData);
                    
    let jqrlxzbPackageData = keyValuePackage(excelData['机器人类型占比'].dataList);
    ret['jqrlxzb'] = getKeyValueOut('机器人类型占比', jqrlxzbPackageData);
                    
    let yhztPackageData = keyValuePackage(excelData['运行状态'].dataList);
    ret['yhzt'] = getKeyValueOut('运行状态', yhztPackageData);
                    
    let yhjlTableData = tablePackage(excelData["运行记录"].headerList[0], excelData["运行记录"].bodyList);
    ret['yhjl'] = getTableOut( '运行记录', yhjlTableData);
                    
    let jqrsjfxPackageData = keyValuePackage(excelData['机器人数据分析'].dataList);
    ret['jqrsjfx'] = getKeyValueOut('机器人数据分析', jqrsjfxPackageData);
                    
    let znxjPackageData = keyValuePackage(excelData['智能巡检'].dataList);
    ret['znxj'] = getKeyValueOut('智能巡检', znxjPackageData);
                    
    let xjsblxPackageData = onceYBarChartPackage( excelData['巡检设备类型'], '次数','');
    ret['xjsblx'] = getOnceYBarChartOut('巡检设备类型', xjsblxPackageData);
                    
    let xjwcqkPackageData = keyValuePackage(excelData['巡检完成情况'].dataList);
    ret['xjwcqk'] = getKeyValueOut('巡检完成情况', xjwcqkPackageData);
                    
    let xjqsPackageData = onceYBarChartPackage( excelData['巡检趋势'], '次数','');
    ret['xjqs'] = getOnceYBarChartOut('巡检趋势', xjqsPackageData);
                    
    let xjjlTableData = tablePackage(excelData["巡检记录"].headerList[0], excelData["巡检记录"].bodyList);
    ret['xjjl'] = getTableOut( '巡检记录', xjjlTableData);
                    
    let znjqrclPackageData = keyValuePackage(excelData['智能机器人产量'].dataList);
    ret['znjqrcl'] = getKeyValueOut('智能机器人产量', znjqrclPackageData);
                    
    let jbnclqsPackageData = onceYBarChartPackage( excelData['近半年产量趋势'], '','月');
    ret['jbnclqs'] = getOnceYBarChartOut('近半年产量趋势', jbnclqsPackageData);
                     
    res.send(ret);
} 