
import { systemConfig } from '../config/serverConfig';
import { jdaqglTableData } from '../data/table/jdaqglData';
import { doubleYBarCharPackage, keyValuePackage, onceYBarChartPackage, rankPackage, tablePackage } from '../dataPackage/inFrontOut';
import { getDoubleYBarChartOut, getKeyValueOut, getOnceYBarChartOut, getTableOut } from '../dataPackage/out';

/*                            基地安全管理                    */

export function getData(req, res) {
    let excelData = jdaqglTableData();

    let ret:any = {};

    let jqtsbzxqkPackageData = onceYBarChartPackage( excelData['近七天设备在线情况'], '','');
    ret['jqtsbzxqk'] = getOnceYBarChartOut('近七天设备在线情况', jqtsbzxqkPackageData);
                    
    let sblxzbPackageData = keyValuePackage(excelData['设备类型占比'].dataList);
    ret['sblxzb'] = getKeyValueOut('设备类型占比', sblxzbPackageData);
                    
    let sbslPackageData = keyValuePackage(excelData['设备数量'].dataList);
    ret['sbsl'] = getKeyValueOut('设备数量', sbslPackageData);
                    
    let sbztqkPackageData = keyValuePackage(excelData['设备状态情况'].dataList);
    ret['sbztqk'] = getKeyValueOut('设备状态情况', sbztqkPackageData);
                    
    let xfsbPackageData = keyValuePackage(excelData['消防设备'].dataList);
    ret['xfsb'] = getKeyValueOut('消防设备', xfsbPackageData);
                    
    let xfsbztPackageData = keyValuePackage(excelData['消防设备状态'].dataList);
    ret['xfsbzt'] = getKeyValueOut('消防设备状态', xfsbztPackageData);
                    
    let jdaqglsjfxPackageData = keyValuePackage(excelData['基地安全管理数据分析'].dataList);
    ret['jdaqglsjfx'] = getKeyValueOut('基地安全管理数据分析', jdaqglsjfxPackageData);
                    
    let zcztlbTableData = tablePackage(excelData["正常状态列表"].headerList[0], excelData["正常状态列表"].bodyList);
    ret['zcztlb'] = getTableOut( '正常状态列表', zcztlbTableData);

    let whzztlbTableData = tablePackage(excelData["维护中状态列表"].headerList[0], excelData["维护中状态列表"].bodyList);
    ret['whzztlb'] = getTableOut( '维护中状态列表', whzztlbTableData);

    let gzztlbTableData = tablePackage(excelData["故障状态列表"].headerList[0], excelData["故障状态列表"].bodyList);
    ret['gzztlb'] = getTableOut( '故障状态列表', gzztlbTableData);
                    
    let tqsjPackageData = keyValuePackage(excelData['天气数据'].dataList);
    ret['tqsj'] = getKeyValueOut('天气数据', tqsjPackageData);
                    
    let sbyhjcPackageData = keyValuePackage(excelData['设备运行监测'].dataList);
    ret['sbyhjc'] = getKeyValueOut('设备运行监测', sbyhjcPackageData);

    let jgcsPackageData = keyValuePackage(excelData['警告次数'].dataList);
    ret['jgcs'] = getKeyValueOut('警告次数', jgcsPackageData);
                    
    let jjcdPackageData = keyValuePackage(excelData['紧急程度'].dataList);
    ret['jjcd'] = getKeyValueOut('紧急程度', jjcdPackageData);
                    
    let gjqsPackageData = onceYBarChartPackage( excelData['告警趋势'], '个','');
    ret['gjqs'] = getOnceYBarChartOut('告警趋势', gjqsPackageData);
                    
    let yjczPackageData = keyValuePackage(excelData['预警处置'].dataList);
    ret['yjcz'] = getKeyValueOut('预警处置', yjczPackageData);

    let yjczlPackageData = keyValuePackage(excelData['预警处置率'].dataList);
    ret['yjczl'] = getKeyValueOut('预警处置率', yjczlPackageData);
                    
    // let zdqyjkPackageData = keyValuePackage(excelData['重点区域监控'].dataList);
    // ret['zdqyjk'] = getKeyValueOut('重点区域监控', zdqyjkPackageData);
    let zdqyjkTableData = tablePackage(excelData["重点区域监控"].headerList[0], excelData["重点区域监控"].bodyList);
    ret['zdqyjk'] = getTableOut( '重点区域监控', zdqyjkTableData);
    // let zdqyjkData = [];
    // zdqyjkPackageData.forEach( info => {
    //     let {key, value} = info;
    //     let imgUrl = `${systemConfig.imgPath}/${key}.png`;
    //     zdqyjkData.push({key, value, imgUrl});
    // })
    // ret['zdqyjk'] = {title:"重点区域监控", dataList:zdqyjkData};
                    
    let yjczbTableData = tablePackage(excelData["预警处置表"].headerList[0], excelData["预警处置表"].bodyList);
    ret['yjczb'] = getTableOut( '预警处置表', yjczbTableData);
                     
    res.send(ret);
} 