/**
 * 高新企业创新能力评价答题
 */

import asyncHandler = require('express-async-handler');
import * as gaoxinBiz from '../biz/answer';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/xcx/gaoxin/answer/list', checkUser, asyncHandler(gaoxinAnswerList));
    httpServer.post('/xcx/gaoxin/answer/option', checkUser, asyncHandler(gaoxinAnswerOption));
    httpServer.post('/xcx/gaoxin/answer/addanswerrecord', checkUser, asyncHandler(addAnswerrecord));
    httpServer.post('/xcx/gaoxin/answer/enterpriseresults', checkUser, asyncHandler(enterpriseResults));
    httpServer.post('/xcx/gaoxin/answer/zufangoption', checkUser, asyncHandler(zuFangAnswerOption));
    httpServer.post('/xcx/gaoxin/answer/addzufanganswerrecord', checkUser, asyncHandler(addZuFangAnswerrecord));
    httpServer.post('/xcx/gaoxin/answer/enterprisezufangresults', checkUser, asyncHandler(enterpriseZuFangResults));
    // httpServer.post('/xcx/gaoxin/answer/changeanswerstatu', checkUser, asyncHandler(changeAnswerStatu));
    // httpServer.post('/xcx/gaoxin/answer/calculategrowthscore', checkUser, asyncHandler(calculateGrowthScore));
    
}


/**
 * 是否有资格开始测评
 * @param req 
 * @param res 
 */
async function gaoxinAnswerList(req, res) {
    const UserInfo = req.userInfo;
    let result = await gaoxinBiz.gaoxinAnswerList(UserInfo.eId);

    res.success(result); 
}


/**
 * 题目
 * @param req 
 * @param res 
 */
async function gaoxinAnswerOption(req, res) {
    const UserInfo = req.userInfo;
    let result = await gaoxinBiz.gaoxinAnswerOption();

    res.success(result);
}


/**
 * 获取高新技术企业自评结果
 * @param req 
 * @param res 
 */
async function enterpriseResults(req, res) {
    const UserInfo = req.userInfo;
    let {garId} = req.body;
    let result = await gaoxinBiz.enterpriseResults(garId);

    res.success(result);
}


/**
 * 存储答题明细
 * @param req 
 * @param res 
 */
async function addAnswerrecord(req, res) {
    const UserInfo = req.userInfo;
    let {gaId, options, assetGrowth, revenueGrowth} = req.body;
    let result = await gaoxinBiz.addAnswerrecord(UserInfo.eId, gaId, options, assetGrowth, revenueGrowth);

    res.success(result);
}


/**
 * 租房题目
 * @param req 
 * @param res 
 */
async function zuFangAnswerOption(req, res) {
    const UserInfo = req.userInfo;
    let result = await gaoxinBiz.zuFangAnswerOption();

    res.success(result);
}


/**
 * 租房存储答题明细
 * @param req 
 * @param res 
 */
async function addZuFangAnswerrecord(req, res) {
    const UserInfo = req.userInfo;
    let {zaId, options} = req.body;
    let result = await gaoxinBiz.addZuFangAnswerrecord(UserInfo.eId, zaId, options);

    res.success(result);
}


/**
 * 获取高新技术企业自评结果
 * @param req 
 * @param res 
 */
async function enterpriseZuFangResults(req, res) {
    const UserInfo = req.userInfo;
    let {zarId} = req.body;
    let result = await gaoxinBiz.enterpriseZuFangResults(zarId);

    res.success(result);
}



/**
 * 完成全部答题
 * @param req 
 * @param res 
 */
// async function changeAnswerStatu(req, res) {
//     const UserInfo = req.userInfo;
//     let {garId} = req.body;
//     let result = await gaoxinBiz.changeAnswerStatu(garId);

//     res.success(result);
// }


/**
 * 企业成长性评分
 * @param req 
 * @param res 
 */
// async function calculateGrowthScore(req, res) {
//     const UserInfo = req.userInfo;
//     let {assetGrowth, revenueGrowth} = req.body;
//     let result = await gaoxinBiz.calculateGrowthScore(assetGrowth, revenueGrowth);

//     res.success(result);
// }







