import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/dbEnum";
import { operationalData } from "../data/operationalData";
import { getMySqlMs } from "../tools/system";

const nodemailer = require('nodemailer');

// 创建一个 SMTP 客户端配置（动态生成）
function createTransporter(user: string, pass: string) {
    return nodemailer.createTransport({
        host: 'smtp.qq.com', // 邮箱服务器地址
        port: 465, // 端口号
        secure: true, // 是否使用安全传输协议
        auth: {
            user, // 发件人邮箱地址
            pass // 发件人邮箱授权码
        }
    });
}

// 发送邮件的函数（支持动态发件人配置）
async function sendEmail(to: string,subject: string,text: string,user: string,pass: string): Promise<void> {
    const transporter = createTransporter(user, pass);
    let mailOptions = {
        from: user, // 动态设置发件人地址
        to: to, // 收件人地址
        subject: subject, // 邮件主题
        text: text // 邮件正文
    };
    try {
        await transporter.sendMail(mailOptions);
        console.log('邮件发送成功');
    } catch (error) {
        console.error('邮件发送失败:', error);
        throw error; // 抛出错误以便调用方处理
    }
}


/**
 * 根据收件人邮箱地址选择合适的发件人邮箱
 * @param email 收件人邮箱地址
 * @returns 发件人邮箱地址和授权码
 */
function getSenderInfo(email: string): { user: string; pass: string } {
    // 根据收件人邮箱地址选择合适的发件人邮箱
    // 这里可以根据业务需求进行扩展，例如根据域名选择不同的发件人
    if (email.endsWith('@example.com')) {
        return { user: 'example_sender@example.com', pass: 'example_password' };
    } else if (email.endsWith('@anotherdomain.com')) {
        return { user: 'another_sender@anotherdomain.com', pass: 'another_password' };
    } else {
        return { user: '1685675085@qq.com', pass: 'hppnsfvnzzhlbdfh' }; // 默认发件人邮箱
        // return { user: 'wdc18234720432@163.com', pass: 'GYhamUicpFavmnGY' };
    }
}

/**
 * 发送验证码到指定邮箱
 * @param email 用户邮箱
 */
function randomInt(min: number, max: number): number {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

export async function sendVerificationCode(email: string): Promise<{ success: boolean; message: string; code?: string }> {
    try {
        // 生成6位数字验证码
        const code = String(randomInt(100000, 999999));

        // 获取发件人信息
        const { user, pass } = getSenderInfo(email);

        // 构造邮件内容
        const mailOptions = {
            to: email,
            subject: "羽翼小程序的专属验证码",
            text: `您的验证码为：${code}，5分钟内有效，请妥善保管。`
        };

        // 发送邮件（支持动态发件人配置）
        await sendEmail(mailOptions.to, mailOptions.subject, mailOptions.text, user, pass);

        // 更新数据库，存储验证码和发送时间
        let updateResult = await operationalData(OPERATIONALDATATYPE.修改,TABLENAME.企业用户表,{ code, codeMs: getMySqlMs() },{ email });

        if (!updateResult) {
            return { success: false, message: '数据库更新失败' };
        }

        return { success: true, message: '验证码发送成功', code };
    } catch (error) {
        console.error('验证码发送失败:', error);
        return { success: false, message: '验证码发送失败' };
    }
}





/**
 *备份的发送验证码到指定邮箱
 */
// import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/dbEnum";
// import { operationalData } from "../data/operationalData";
// import { getMySqlMs } from "../tools/system";


// const nodemailer = require('nodemailer');

// // 创建一个 SMTP 客户端配置
// let transporter = nodemailer.createTransport({
//     host: 'smtp.qq.com', // 邮箱服务器地址
//     port: 465, // 端口号
//     secure: true, // 是否使用安全传输协议
//     auth: {
//         user: '1685675085@qq.com', // 发件人邮箱地址
//         pass: 'hppnsfvnzzhlbdfh' // 发件人邮箱授权码
//     }
// })

// // 发送邮件的函数
// async function sendEmail(to: string, subject: string, text: string) {
//     let mailOptions = {
//         from: '1685675085@qq.com', // 发件人地址
//         to: to, // 收件人地址
//         subject: subject, // 邮件主题
//         text: text // 邮件正文
//     };
//     try {
//         await transporter.sendMail(mailOptions);
//         console.log('邮件发送成功');
//         return text;
//     }
//     catch (error) {
//         console.error('邮件发送失败:', error);
//         return error;
//     }
// }


// /**
//  * 发送验证码到指定邮箱
//  * @param email 用户邮箱
//  */

// function randomInt(min: number, max: number): number {
//     return Math.floor(Math.random() * (max - min + 1)) + min;
// }

// export async function sendVerificationCode(email: string): Promise<{}> {
//     // 生成6位数字验证码
//     const code = String(randomInt(100000, 999999));

//     // 构造邮件内容
//     const mailOptions = {
//         to: email,
//         subject: "羽翼小程序的专属验证码",
//         text: `您的验证码为：${code}，5分钟内有效，请妥善保管。`
//     };

//     // 发送邮件
//     await sendEmail(mailOptions.to, mailOptions.subject, mailOptions.text);

//     // 更新数据库，存储验证码和发送时间
//     await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, { code, codeMs: getMySqlMs() }, { email });
  
//     return code;
// }
