/**
 * 文件管理 路由
 */

import * as asyncHandler from 'express-async-handler';
import * as fileBiz from '../biz/file';
import { checkUser } from '../middleware/user';
import { parseFormParam } from '../middleware/fromParam';


export function setRouter(httpServer) {
    httpServer.post('/xcx/files/honor/up', checkUser, parseFormParam, asyncHandler(upPolicyBackground));
}

async function upPolicyBackground(req, res) {
    let result = await fileBiz.upFile( req.files, req.fileType);
    res.success(result);
}
