/**
 * 资质
 */

import * as asyncHandler from 'express-async-handler';
import * as qualificationBiz from '../biz/qualification';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
        /**知识产权 */
        httpServer.post('/xcx/qualification/ipr/list', checkUser, asyncHandler(iprList));
        httpServer.post('/xcx/qualification/ipr/listbytype', checkUser, asyncHandler(iprListByType));
        httpServer.post('/xcx/qualification/ipr/update', checkUser, asyncHandler(iprUpdate));
        httpServer.post('/xcx/qualification/ipr/add', checkUser, asyncHandler(iprAdd));
        httpServer.post('/xcx/qualification/ipr/del', checkUser, asyncHandler(iprDel));
        /**专利 */
        httpServer.post('/xcx/qualification/patent/list', checkUser, asyncHandler(patentList));
        httpServer.post('/xcx/qualification/patent/update', checkUser, asyncHandler(patentUpdate));
        httpServer.post('/xcx/qualification/patent/add', checkUser, asyncHandler(patentAdd));
        httpServer.post('/xcx/qualification/patent/del', checkUser, asyncHandler(patentDel));
        /**资质认证 */
        httpServer.post('/xcx/qualification/authentication/info', checkUser, asyncHandler(authenticationInfo));
        httpServer.post('/xcx/qualification/authentication/update', checkUser, asyncHandler(authenticationUpdate));
        /**荣誉奖项 */
        httpServer.post('/xcx/qualification/honor/list', checkUser, asyncHandler(honorList));
        httpServer.post('/xcx/qualification/honor/update', checkUser, asyncHandler(honorUpdate));
        httpServer.post('/xcx/qualification/honor/add', checkUser, asyncHandler(honorAdd));
        httpServer.post('/xcx/qualification/honor/del', checkUser, asyncHandler(honorDel));
}


//===================================知识产权
/**
 * 
 * @param req 
 * @param res 
 */
async function iprList(req, res) {
    const UserInfo = req.userInfo;
    let result = await qualificationBiz.enterpriseIPRInfo(UserInfo.eId);

    res.success(result);
}


async function iprListByType(req, res) {
    const UserInfo = req.userInfo;
    let {iprType } = req.body;
    let result = await qualificationBiz.enterpriseIPRByType(UserInfo.eId, iprType);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function iprUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, iprId } = req.body
    let result = await qualificationBiz.updateEnterpriseIPRInfo(UserInfo.eId, iprId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function iprAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param} = req.body
    let result = await qualificationBiz.createEnterpriseIPRInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function iprDel(req, res) {
    const UserInfo = req.userInfo;
    let {iprId} = req.body
    let result = await qualificationBiz.deleteEnterpriseIPRInfo(UserInfo.eId, iprId);

    res.success(result);
}



//====================================专利
/**
 * 
 * @param req 
 * @param res 
 */
async function patentList(req, res) {
    const UserInfo = req.userInfo;
    let result = await qualificationBiz.enterprisePatentInfo(UserInfo.eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function patentUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, pId, file } = req.body
    let result = await qualificationBiz.updateEnterprisePatentInfo(UserInfo.eId, pId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function patentAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param, file } = req.body
    let result = await qualificationBiz.createEnterprisePatentInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function patentDel(req, res) {
    const UserInfo = req.userInfo;
    let {tId } = req.body
    let result = await qualificationBiz.deleteEnterprisePatentInfo(UserInfo.eId, tId);

    res.success(result);
}


//=================================================资质认证
/**
 * 
 * @param req 
 * @param res 
 */
async function authenticationInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await qualificationBiz.enterpriseQualificationInfo(UserInfo.eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function authenticationUpdate(req, res) {
    const UserInfo = req.userInfo;
    let { param } = req.body
    let result = await qualificationBiz.updateEnterpriseQualificationInfo(UserInfo.eId, param);

    res.success(result);
}


//===============================================荣誉奖项
/**
 * 
 * @param req 
 * @param res 
 */
async function honorList(req, res) {
    const UserInfo = req.userInfo;
    let result = await qualificationBiz.enterpriseHonorInfo(UserInfo.eId);

    res.success(result);
}
/**
 * 
 * @param req 
 * @param res 
 */
async function honorUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, hId } = req.body
    let result = await qualificationBiz.updateEnterpriseHonorInfo(UserInfo.eId, hId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function honorAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await qualificationBiz.createEnterpriseHonorInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function honorDel(req, res) {
    const UserInfo = req.userInfo;
    let {hId} = req.body;
    let result = await qualificationBiz.deleteEnterpriseHonorInfo(UserInfo.eId, hId);

    res.success(result);
}













