/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseInfoBiz from '../biz/enterpriseInfo';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
    //登录登出
    httpServer.post('/xcx/enterprise/login', asyncHandler(login));
    httpServer.post('/xcx/enterprise/logout', checkUser, asyncHandler(logout));

    /**首页 */
    httpServer.post('/xcx/enterprise/home/enterpriselist', checkUser, asyncHandler(enterpriseByPhoneList));
    httpServer.post('/xcx/enterprise/home/top', checkUser, asyncHandler(homePageTop));

    httpServer.post('/xcx/enterprise/home/task', checkUser, asyncHandler(homePageTask));
    httpServer.post('/xcx/enterprise/home/tasksubmit', checkUser, asyncHandler(homePageTaskSubmit));
    httpServer.post('/xcx/enterprise/home/year', checkUser, asyncHandler(homePageYear));
    /**基本信息 */
    httpServer.post('/xcx/enterprise/base/info', checkUser, asyncHandler(baseInfo));
    /**我的信息 */
    httpServer.post('/xcx/enterprise/myinfo/info', checkUser, asyncHandler(myInfo));
    httpServer.post('/xcx/enterprise/myinfo/update', checkUser, asyncHandler(updateMyInfo));
    /**法人信息 */
    httpServer.post('/xcx/enterprise/faren/info', checkUser, asyncHandler(faRenInfo));
    httpServer.post('/xcx/enterprise/faren/update', checkUser, asyncHandler(updateFaRenInfo));
    /**入驻信息 */
    httpServer.post('/xcx/enterprise/ruzhu/info', checkUser, asyncHandler(ruZhuInfo));

    //=============政策速递
    httpServer.post('/xcx/policy/list', checkUser, asyncHandler(policyList));
    httpServer.post('/xcx/policy/info', checkUser, asyncHandler(policyInfo));

    // //=============企业服务
    httpServer.post('/xcx/services/record/list', checkUser, asyncHandler(servicesList));
    httpServer.post('/xcx/services/record/del', checkUser, asyncHandler(servicesDelete));
    httpServer.post('/xcx/services/record/info', checkUser, asyncHandler(servicesInfo));
    httpServer.post('/xcx/services/applyfor/add', checkUser, asyncHandler(servicesAdd));

}



//====================================政策速递

/**
 * 
 * @param req 
 * @param res 
 */
async function policyList(req, res) {
    const UserInfo = req.userInfo;
    let { state } = req.body;
    let result = await enterpriseInfoBiz.enterprisePolicyList(state);

    res.success(result);
}
/**
 * 
 * @param req 
 * @param res 
 */
async function policyInfo(req, res) {
    const UserInfo = req.userInfo;
    let { poId } = req.body;
    let result = await enterpriseInfoBiz.enterprisePolicyInfo(poId);

    res.success(result);
}


//=-=============================================企业服务
/**
 * 
 * @param req 
 * @param res 
 */
async function servicesList(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseServiceList(UserInfo.eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function servicesDelete(req, res) {
    const UserInfo = req.userInfo;
    let {esId } = req.body
    let result = await enterpriseInfoBiz.deleteEnterpriseServiceInfo(UserInfo.eId, esId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function servicesInfo(req, res) {
    const UserInfo = req.userInfo;
    let {esId} = req.body
    let result = await enterpriseInfoBiz.enterpriseServiceInfo(UserInfo.eId, esId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function servicesAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param} = req.body
    let result = await enterpriseInfoBiz.createEnterpriseServiceInfo(UserInfo.eId, param);

    res.success(result);
}


//----------------------------------------------登录

/**
 * 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let {phone, pwd } = req.body
    let result = await enterpriseInfoBiz.enterpriseLogin(phone, pwd );

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function logout(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseLeaseInfo(UserInfo.eId);

    res.success(result);
}


//===============================入驻
/**
 * 
 * @param req 
 * @param res 
 */
async function ruZhuInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseLeaseInfo(UserInfo.eId);

    res.success(result);
}


//===============================法人信息
/**
 * 
 * @param req 
 * @param res 
 */
async function faRenInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseFaRenInfo(UserInfo.eId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function updateFaRenInfo(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await enterpriseInfoBiz.updateEnterpriseFaRenInfo(UserInfo.eId, param);

    res.success(result);
}


//=================================我的信息
/**
 * 
 * @param req 
 * @param res 
 */
async function myInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseInfomation(UserInfo.eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function updateMyInfo(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await enterpriseInfoBiz.updateEnterpriseInfomation(UserInfo.eId, param);

    res.success(result);
}


//===================================基本信息
/**
 * 
 * @param req 
 * @param res 
 */
async function baseInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.enterpriseBaseInfo(UserInfo.eId);

    res.success(result);
}


async function homePageTaskSubmit(req, res) {
    const UserInfo = req.userInfo;
    let { mId } = req.body; 
    let result = await enterpriseInfoBiz.submitTask(UserInfo.eId, mId);

    res.success(result);
}


async function enterpriseByPhoneList(req, res) {
    const UserInfo = req.userInfo;
    let {phone} = req.body
    let result = await enterpriseInfoBiz.enterpriseByPhone(phone);

    res.success(result);
}


/**
 * 首页
 * @param req 
 * @param res 
 */
async function homePageTop(req, res) {
    const UserInfo = req.userInfo;
    let result = await enterpriseInfoBiz.homePage(UserInfo.eId);

    res.success(result);
}

/**
 * 首页-任务
 * @param req 
 * @param res 
 */
async function homePageTask(req, res) {
    const UserInfo = req.userInfo;
    let {state, annual} = req.body
    let result = await enterpriseInfoBiz.taskList(UserInfo.eId, annual, state);

    res.success(result);
}

/**
 * 首页经营数据任务填报 下拉选择季度
 * @param req 
 * @param res 
 */
async function homePageYear(req, res) {
    let nowTime = new Date();
    let year = nowTime.getFullYear();
    let quarterConf = ["第一季度", "第二季度", "第三季度", "第四季度"];
    let month = nowTime.getMonth();
    let quarter = Math.floor(month / 3) + 1;

    let result = {dataList:[]};
    
    for (let i = 2024; i <= year; i++) {
        for(let j = 1; j <= quarterConf.length; j++) {
            let item = quarterConf[j-1];
            if (i != year){
                result.dataList.push({year:`${i}${item}`});
            } else {
                if (j <= quarter) {
                    result.dataList.push({year:`${i}${item}`});
                }
            }
        }
    }

    res.success(result);
}




