/**
 * 校验表单参数配置 【小程序】
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */

export const EnterpriseInfomationUpdateConfig = {
    tongXinDiZhi:{type:"Address"},//通信地址
    industry:{type:"[Number]"},//领域
    mail:{type:"String"},//邮箱
    liaison:{type:"String"},//联系人
    liaisonPhone:{type:"String"},//联系电话
    gengDuoDianHua:{type:"String"},//更多电话
    jianJie:{type:"String"},//简介
    mainBusiness:{type:"String"},//主营业务
}



export const EnterpriseFaRenInfoUpdateConfig = {
    name:{type:"String"}, //姓名
    idCard:{type:"String"}, //身份证
    domicile:{type:"String"}, //户籍
    degree:{type:"Number"}, //学历
    politicalStatus:{type:"Number"}, //政治面貌
    phone:{type:"String"}, //手机号码
}


export const EnterpriseIPRUpdateConfig = {
    year:{type:"Number"}, //年度
    // number:{type:"Number"}, //个数
    iprType:{type:"Number"}, //专利类型【枚举】
    iprName:{type:"String"},  //专利名称
    iprUrl:{type:"[String"},//证明材料
}


export const EnterprisePatentUpdateConfig = {
    year:{type:"Number"}, //年度
    alienPatent:{type:"Number"},//海外专利个数
    classIPatent:{type:"Number"},//一类专利个数
    secondClassPatent:{type:"Number"},//二级专利个数
    thirdPentent:{type:"Number"},//三级专利个数
}


export const EnterpriseQualificationUpdateConfig = {
    kxState:{key:"Number", notMustHave:true},//科小认定状态
    kxTime:{key:"Number", notMustHave:true},//科小认定时间
    kxImg:{key:"[String]", notMustHave:true},//新增科小图片
    kxNumber:{key:"Number", notMustHave:true},//新增科小认定编号
    zjtxState:{key:"Number", notMustHave:true},//专精特新认定状态
    zjtxImg:{key:"[String]", notMustHave:true},//新增专精特新图片
    zjtxTime:{key:"Number", notMustHave:true},//专精特新认定时间
    xjrImg:{key:"[String]", notMustHave:true},//新增小巨人证书
    xjrState:{key:"Number", notMustHave:true},//小巨人认定状态
    xjrTime:{key:"Number", notMustHave:true},//小巨人认定时间
    xjrPyTime:{key:"Number", notMustHave:true},//小巨人培育认定时间
    xjrPyState:{key:"Number", notMustHave:true},//小巨人培育认定状态
    xjrPyImg:{key:"[String]", notMustHave:true},//新增小巨人培育证书
    gaoXinJiShuTime:{key:"Number", notMustHave:true},// 新增高新技术认定时间
    gaoXinJiShuImg:{key:"[String]", notMustHave:true},//新增高新技术图片
    gxjsState:{key:"Number", notMustHave:true},//高新技术状态
    listedState:{key:"Number", notMustHave:true},//上市状态
    goPublicTime:{key:"Number", notMustHave:true},//上市时间
    goPublicSector:{key:"[Number]", notMustHave:true},//上市板块
    other:{key:"Number", notMustHave:true},//新增其他
}





export const EnterpriseAwardUpdateConfig = {
    awardName:{key:"String"},//奖项名称
    awardingUnit:{key:"String"},//颁奖单位
    awardTime:{key:"Number"},//获奖日期
    awardLevel:{key:"Number"},//奖项等级
    awardImg:{key:"[String]"}//关联图片
}




export const EnterpriseTeamUpdateConfig = {
    name:{key:"String"},//姓名
    sex:{key:"Number"},//性别
    birth:{key:"Number"},//出生年月
    degree:{key:"Number"},//最高学历
    graduationSchool:{key:"String"},//毕业学校
    talentType:{key:"Number"},//人才类型
    des:{key:"String"},//履历描述
    certificateImg:{key:"[String]"},//新增关联图片
}




export const EnterpriseCanBaoUpdateConfig = {
    annual:{key:"Number"},//所属年报
    zhuanKe:{key:"Number"},//专科
    benKe:{key:"Number"},//本科
    // yanJiuSheng:{key:"Number"},//研究生
    shuoshi:{key:"Number"},//硕士
    boShi:{key:"Number"},//博士
    boshiyishang:{key:"Number"},//新增博士以上
    qiTa:{key:"Number"},//其他
}



export const EnterpriseFinancingUpdateConfig = {
    financingAmount:{key:"Number"},//融资金额（万元）
    financingRounds:{key:"Number"},//融资轮次【枚举】
    fuHuaQiInvestment:{key:"Number"},//孵化器是否参与投资【枚举】
    fuHuaQiInvestmentStyle:{key:"String", notMustHave:true},//孵化器投资方式
    fuHuaQiInvestmentAmount:{key:"Number", notMustHave:true},//孵化器投资金额
    investmentDate:{key:"Number"},//获得投资时间
    investmentInstitutionsName:{key:"String"},//投资机构名称
    valuation:{key:"String"},//估值
}


export const EnterpriseServiceUpdateConfig = {
    needCategory:{key:"Number"},//需求类别
    needContent:{key:"String"},//需求内容
}


export const EnterpriseManageInfoUpdateConfig = {
    // annual:{type:"Number"}, //新增年度
    // quarter:{type:"Number"},//新增季度
    BI:{type:"Number"},//营业收入
    TXP:{type:"Number"},//纳税
    RD:{type:"Number"},//研发投入

}


export const EnterpriseManageInfoAddConfig = {
    annual:{type:"Number"}, //年度
    quarter:{type:"Number"}, //新增季度
    BI:{type:"Number"},//营业收入
    TXP:{type:"Number"},//纳税
    RD:{type:"Number"},//研发投入
}
