/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
import { TABLEID } from "../config/enum/dbEnum";

const md5 = require("md5");


/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


export function randomId(tableName:string) {
    let randomStr = `${new Date().valueOf()}_${Math.ceil(Math.random()*100000)}`;
    return `${tableName}_${md5(randomStr)}`;
}

export function getMySqlMs(time?) {
    time = new Date(time).valueOf() || new Date().valueOf();
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}

/**
 * 获取上季度
 */
export function getLastDeclarationTime() {
    let thisYear = new Date().getFullYear();
    let thisQuarter = moment().quarter();//当月填报季度
    if ( (thisQuarter - 1) < 1 ) {
        thisYear = moment().subtract(1, 'years').year();
        thisQuarter = 4;
    } else thisQuarter = thisQuarter - 1;
    return {declarationYear:getMySqlMs(`${thisYear}-01-01 00:00:00`), declarationQuarter:thisQuarter};
}

/**
 * 获取本季度
 */
export function getDeclarationTime() {
    let thisYear = new Date().getFullYear();
    return {declarationYear:getMySqlMs(`${thisYear}-01-01 00:00:00`)};
    // let thisQuarter = moment().quarter();//当月填报季度
    // return {declarationYear:getMySqlMs(`${thisYear}-01-01 00:00:00`), declarationQuarter:thisQuarter};
}
    
/**
 * 去除地址包含相同上海市上海市问题
 * @param address 
 */
export function getAddresList(address) {
    let logonAddress = [];
    if (address) {
        let logonAddressList = JSON.parse(address || '[]')
        for (let i = 0; i < logonAddressList.length; i++) {
            if (logonAddressList[i] != logonAddressList[i+1]) logonAddress.push(logonAddressList[i]);
        } 
    }
    return logonAddress;
}




