/**
 * 企业团队
 */

import asyncHandler = require('express-async-handler');
import * as teamsBiz from '../biz/teams';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
    /**创业团队 */
    httpServer.post('/xcx/teams/originate/list', checkUser, asyncHandler(originateInfo));
    httpServer.post('/xcx/teams/originate/update', checkUser, asyncHandler(originateUpdate));
    httpServer.post('/xcx/teams/originate/add', checkUser, asyncHandler(originateAdd));
    httpServer.post('/xcx/teams/originate/del', checkUser, asyncHandler(originateDel));
    /**参保信息 */
    httpServer.post('/xcx/teams/canbao/list', checkUser, asyncHandler(canBaoInfo));
    httpServer.post('/xcx/teams/canbao/update', checkUser, asyncHandler(canBaoUpdate));
    httpServer.post('/xcx/teams/canbao/add', checkUser, asyncHandler(canBaoAdd));
    httpServer.post('/xcx/teams/canbao/del', checkUser, asyncHandler(canBaoDel));
}


//-------------------------------------------------创业团队

/**
 * 
 * @param req 
 * @param res 
 */
async function originateInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await teamsBiz.enterpriseTeamInfo(UserInfo.eId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function originateUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, tId } = req.body
    let result = await teamsBiz.updateEnterpriseTeamInfo(UserInfo.eId, tId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function originateAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await teamsBiz.createEnterpriseTeamInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function originateDel(req, res) {
    const UserInfo = req.userInfo;
    let {tId } = req.body
    let result = await teamsBiz.deleteEnterpriseTeamInfo(UserInfo.eId, tId);

    res.success(result);
}


//==================================================参保信息
/**
 * 
 * @param req 
 * @param res 
 */
async function canBaoInfo(req, res) {
    const UserInfo = req.userInfo;
    let result = await teamsBiz.enterpriseCanBaoInfo(UserInfo.eId);

    res.success(result);
}
/**
 * 
 * @param req 
 * @param res 
 */
async function canBaoUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, cId } = req.body
    let result = await teamsBiz.updateEnterpriseCanBaoInfo(UserInfo.eId, cId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function canBaoAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await teamsBiz.createEnterpriseCanBaoInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function canBaoDel(req, res) {
    const UserInfo = req.userInfo;
    let {cId} = req.body
    let result = await teamsBiz.deleteEnterpriseCanBaoInfo(UserInfo.eId, cId);

    res.success(result);
}





