/**
 * 企业消息通知
 */

import asyncHandler = require('express-async-handler');
import * as massageNoticeBiz from '../biz/massageNotice';
import { checkUser } from '../middleware/user';


export function setRouter(httpServer) {
    httpServer.post('/xcx/enterprise/massagnotice/list', checkUser, asyncHandler(notificationList));
    httpServer.post('/xcx/enterprise/massagnotice/markasread', checkUser, asyncHandler(markAsRead));
    
}


/**
 * 获取登录用户的企业消息通知列表
 * @param req 
 * @param res 
 */
async function notificationList(req, res) {
    const UserInfo = req.userInfo;
    let result = await massageNoticeBiz.getPopupNotifications(UserInfo.eId);

    res.success(result);
}


/**
 * 标记通知为已读
 * @param req 
 * @param res 
 */
async function markAsRead(req, res) {
    let { msgId, readId } = req.body;
    const UserInfo = req.userInfo;
    let result = await massageNoticeBiz.markNotificationAsRead(UserInfo.eId, msgId, readId);

    res.success(result);
}
 
 
 
