
export enum ERRORENUM {
    未找到数据,
    参数错误,
    身份验证失败,
    非法登录,
    身份验证过期,
    code无效,
    频繁操作请稍后再试,
    高风险等级用户,
    系统繁忙,//===系统code除外
    该方法仅可进行查询操作,
    数据操作失败,
    该方法仅可进行数据操作,
    数据查询失败,
    分页请设置当前页数,
    该方法仅可进行联合查询操作,
    数据联合查询失败,
    参数校验失败,
    数据无更新,
    当前数据不存在,
    地址数据不完整,
    只能上传png或jpg图片,
    文件上传失败,
    账号或密码错误,
    不可重复添加同一年度数据,
    数据不存在,
    不可重复提交,
    存在重复的年份数据,
    验证码过期,
    验证码发送失败,
    验证码不存在,
    答题记录不存在,
    账号密码错误,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    原密码错误,
    当前无法提交,
    当前不在填报时间内,
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
    code无效 = 40029,
    频繁操作请稍后再试 = 45011,
    高风险等级用户 = 40226,
    系统繁忙 = 40227
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}