/**
 * 企业团队
 */

import moment = require("moment");
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import { operationalData, selectData } from "../data/operationalData";
import { eccFormParam } from "../util/verificationParam";
import { getMySqlMs, randomId } from "../tools/system";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/enum/errorEnum";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import * as enumConfig from "../config/enum/enum";
import { EnterpriseCanBaoUpdateConfig, EnterpriseTeamUpdateConfig } from "../config/eccParam/enterprise";
import { checkChange } from "../util/piecemeal";


//=======================================团队

/**
 * 创业团队-列表
 * 回显
 * @param uscc 
 */
export async function enterpriseTeamInfo(eId) {
    let filesList = ["tId", "name" ,"sex" ,"birth" ,"degree" ,"graduationSchool" ,"talentType" ,"des","certificateImg"];

    let iprList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.创业团队, {eId}, filesList);
    
    let dataList:any[] = [];
    iprList.forEach(item => {
        let { tId, name, sex, birth, degree, graduationSchool, talentType, des,certificateImg} = item;

        dataList.push({
            tId,
            name,
            sex:changeEnumValue(enumConfig.SEX, sex),
            birth:moment(birth).format("YYYY-MM-DD"),
            degree:changeEnumValue(enumConfig.DEGREE, degree),
            graduationSchool,
            talentType:changeEnumValue(enumConfig.ENTERPRISETEAM, talentType),
            des,
            certificateImg:JSON.parse(certificateImg), // 新增证书图片返回
        });
    });

    return {dataList};
}


/**
 * 创业团队-修改
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function updateEnterpriseTeamInfo(eId, tId, param) {
    const FuncName = "企业修改创业团队"
    eccFormParam(FuncName, EnterpriseTeamUpdateConfig, param );
    param.birth = getMySqlMs(param.birth);
    param.certificateImg = JSON.stringify(param.certificateImg);

    let filesList = ["name" ,"sex" ,"birth" ,"degree" ,"graduationSchool" ,"talentType" ,"des", "certificateImg"];
    let iprInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.创业团队, {tId, eId}, filesList)
    if (!iprInfo || !iprInfo.name) throw new BizError(ERRORENUM.当前数据不存在); 
    /**修改字段 */
    let changeList = checkChange(param, iprInfo);
    if ( !changeList.length ) return {isSuccess:true};
   
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.创业团队, param, {tId, eId});
    
    return {isSuccess:true};
}


/**
 * 创业团队-添加
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function createEnterpriseTeamInfo(eId, param) {
    const FuncName = "企业修改创业团队"
    eccFormParam(FuncName, EnterpriseTeamUpdateConfig, param );
    eccEnumValue(FuncName, 'sex', enumConfig.SEX, param.sex);
    eccEnumValue(FuncName, 'talentType', enumConfig.ENTERPRISETEAM, param.talentType);
    
   
    let addInfo = {
        tId:randomId(TABLEID.创业团队),
        eId,
        name:param.name,
        sex:param.sex,
        birth:getMySqlMs(param.birth),
        degree:param.degree,
        graduationSchool:param.graduationSchool,
        talentType:param.talentType,
        des:param.des,
        certificateImg:JSON.stringify(param.certificateImg),// 新增证书图片返回
    };

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.创业团队, addInfo, {});
    
    return {isSuccess:true};
}


/**
 * 创业团队-删除
 * @param param0 
 * @returns 
 */
export async function deleteEnterpriseTeamInfo(eId, tId) {
    let filesList = ["name" ,"sex" ,"birth" ,"degree" ,"graduationSchool" ,"talentType" ,"des","certificateImg"];
    let iprInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.创业团队, {tId, eId}, filesList)
    if (!iprInfo || !iprInfo.name) throw new BizError(ERRORENUM.当前数据不存在);

    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.创业团队, {}, {tId, eId});
    
    return {isSuccess:true};
}


//==================================================参保人数

/**
 * 参保信息-列表
 * 回显
 * @param uscc 
 */
export async function enterpriseCanBaoInfo(eId) { 
    let filesList = ["cId", "annual" ,"zhuanKe" ,"benKe" ,"shuoshi" ,"boShi" ,"qiTa", "boshiyishang"];
    
    let iprList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.参保记录, {eId}, filesList);
    
    let dataList:any[] = [];
    iprList.forEach(item => {
        let {cId, annual, zhuanKe, benKe, shuoshi, boShi, qiTa, boshiyishang} = item;

        dataList.push({
            cId, 
            annual:new Date(annual).valueOf(), 
            zhuanKe, benKe, shuoshi, boShi, 
            boshiyishang: boshiyishang || 0, 
            qiTa
        });
    });

    //年份倒序排列
    dataList.sort((a, b) => {
        return b.annual - a.annual;
    });

    return {dataList};
}


/**
 * 参保信息-修改
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function updateEnterpriseCanBaoInfo(eId, cId, param) {
    const FuncName = "企业修改参保信息"
    eccFormParam(FuncName, EnterpriseCanBaoUpdateConfig, param );
    

    let filesList = [ "annual" ,"zhuanKe" ,"benKe" ,"shuoshi" ,"boShi", "boshiyishang","qiTa", "cId"];
    let iprInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.参保记录, {cId, eId}, filesList);
    if (!iprInfo || !iprInfo.annual) throw new BizError(ERRORENUM.当前数据不存在); 
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.参保记录, { eId, annual:getMySqlMs(param.annual)}, filesList);
    if (resInfo && resInfo.annual && resInfo.cId != cId) throw new BizError(ERRORENUM.不可重复添加同一年度数据);

    /**修改字段 */
    param.annual = getMySqlMs(param.annual);

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.参保记录, param, {cId, eId});
    
    return {isSuccess:true};
}


/**
 * 参保信息-添加
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function createEnterpriseCanBaoInfo(eId, param) {
    const FuncName = "企业修改参保信息"
    eccFormParam(FuncName, EnterpriseCanBaoUpdateConfig, param );
    let annual = getMySqlMs(param.annual);
    let filesList = [ "annual" ,"zhuanKe" ,"benKe" ,"shuoshi" ,"boShi" ,"boshiyishang","qiTa"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.参保记录, {eId, annual}, filesList);
    if (resInfo && resInfo.annual) throw new BizError(ERRORENUM.不可重复添加同一年度数据);
    let addInfo = {
        cId:randomId(TABLEID.参保记录),
        eId,
        annual,
        zhuanKe:param.zhuanKe,
        benKe:param.benKe,
        shuoshi:param.shuoshi,
        boShi:param.boShi,
        boshiyishang:param.boshiyishang,//博士以上
        qiTa:param.qiTa,
    };

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.参保记录, addInfo, {});
    
    return {isSuccess:true};
}


/**
 * 参保信息-删除
 * @param param0 
 * @returns 
 */
export async function deleteEnterpriseCanBaoInfo(eId, cId) {
    let filesList = [ "annual" ,"zhuanKe" ,"benKe" ,"shuoshi" ,"boShi" ,"boshiyishang","qiTa"];
    let iprInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.参保记录, {cId, eId}, filesList)
    if (!iprInfo || !iprInfo.annual) throw new BizError(ERRORENUM.当前数据不存在);

    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.参保记录, {}, {cId, eId});
    
    return {isSuccess:true};
}





