/**
 * 企业融资
 */

import asyncHandler = require('express-async-handler');
import * as financeBiz from '../biz/finance';
import { checkUser } from '../middleware/user';

export function setRouter(httpServer) {
    /**企业融资 */
    httpServer.post('/xcx/finance/financing/list', checkUser, asyncHandler(financingList));
    httpServer.post('/xcx/finance/financing/update', checkUser, asyncHandler(financingUpdate));
    httpServer.post('/xcx/finance/financing/add', checkUser, asyncHandler(financingAdd));
    httpServer.post('/xcx/finance/financing/del', checkUser, asyncHandler(financingDel));
    /**企业营收 */
    httpServer.post('/xcx/finance/revenue/info', checkUser, asyncHandler(revenueInfo));
    httpServer.post('/xcx/finance/revenue/update', checkUser, asyncHandler(revenueUpdate));
    httpServer.post('/xcx/finance/revenue/add', checkUser, asyncHandler(revenueAdd));
    httpServer.post('/xcx/finance/revenue/del', checkUser, asyncHandler(revenueDel));
    httpServer.post('/xcx/finance/revenue/list', checkUser, asyncHandler(revenueList));

}



//=====================企业融资
/**
 * 
 * @param req 
 * @param res 
 */
async function financingList(req, res) {
    const UserInfo = req.userInfo;
    let result = await financeBiz.enterpriseFinancingInfo(UserInfo.eId);

    res.success(result);
}
/**
 * 
 * @param req 
 * @param res 
 */
async function financingUpdate(req, res) {
    const UserInfo = req.userInfo;
    let {param, rId } = req.body
    let result = await financeBiz.updateEnterpriseFinancingInfo(UserInfo.eId, rId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function financingAdd(req, res) {
    const UserInfo = req.userInfo;
    let {param } = req.body
    let result = await financeBiz.createEnterpriseFinancingInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function financingDel(req, res) {
    const UserInfo = req.userInfo;
    let {rId} = req.body
    let result = await financeBiz.deleteEnterpriseFinancingInfo(UserInfo.eId, rId);

    res.success(result);
}


//====================================经营
/**
 * 
 * @param req 
 * @param res 
 */
async function revenueInfo(req, res) {
    const UserInfo = req.userInfo;
    let { mId } = req.body;
    let result = await financeBiz.enterpriseManageInfo(UserInfo.eId, mId);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function revenueUpdate(req, res) {
    const UserInfo = req.userInfo;
    let { mId, param } = req.body;
    let result = await financeBiz.updateEnterpriseManageInfo(UserInfo.eId, mId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
 async function revenueAdd(req, res) {
    const UserInfo = req.userInfo;
    let { param } = req.body;
    let result = await financeBiz.createEnterpriseManageInfo(UserInfo.eId, param);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function revenueDel(req, res) {
    const UserInfo = req.userInfo;
    let {mId} = req.body
    let result = await financeBiz.deleteEnterpriseManageInfo(UserInfo.eId, mId);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function revenueList(req, res) {
    const UserInfo = req.userInfo;

    let result = await financeBiz.enterpriseManageList(UserInfo.eId);

    res.success(result);
}






