/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
import { TABLEID } from "../config/enum/dbEnum";

const md5 = require("md5");


/**
 * 生成任务草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}



/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}


/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}


export function randomId(tableName:string) {
    let randomStr = `${new Date().valueOf()}_${Math.ceil(Math.random()*100000)}`;
    return `${tableName}_${md5(randomStr)}`;
}

export function getMySqlMs(time?) {
    time = new Date(time).valueOf() || new Date().valueOf();
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}
