/**
 * 公共资源路由
 */
import * as asyncHandler from 'express-async-handler';
import * as enumConfig from '../config/enum/enum';

const config = {
    "/public/industry":enumConfig.INDUSTRY,
    "/public/zzmm":enumConfig.ZZMM,
    "/public/degree":enumConfig.DEGREE,
    "/public/sex":enumConfig.SEX,
    "/public/enterpriseteam":enumConfig.ENTERPRISETEAM,
    "/public/listingsituation":enumConfig.LISTINGSITUATION,
    "/public/awardlevel":enumConfig.AWARDLEVEL,
    "/public/followupstatus":enumConfig.FOLLOWUPSTATUS,
    "/public/needcategory":enumConfig.NEEDCATEGORY,
    "/public/fuhuaqilnvestmentstyle":enumConfig.FUHUAQILNVESTMENTSTYLE,
    "/public/financingrounds":enumConfig.FINANCINGROUNDS,
    // "/public/intellectualpropertyright":enumConfig.INTELLECTUALPROPERTYRIGHT,// 新增知识产权类型
    // "/public/iprtypeclient":enumConfig.IPRTYPECLIENT,// 新增知识产权类型
    "/public/iprtypeclientqt":enumConfig.IPRTYPECLIENTQT,// 新增知识产权类型
    "/public/iprtypeclientzl":enumConfig.IPRTYPECLIENTZL,// 新增知识产权专利
    
}

export function setRouter(httpServer) {
    for (let modelKey in config) {
        httpServer.post(modelKey, asyncHandler(getEnumItf(config[modelKey])));
    }
}


/**
 * 获取行业领域
 * @param req 
 * @param res 
 */
function getEnumItf(enumCof) {
    return async function (req, res) {
        let dataList = [];
        for (let key in enumCof) {
            let anyKey:any = key;
            if (isNaN(anyKey)) {
                dataList.push({key, value:enumCof[key]});
            }
        }
        // console.log(dataList);
        res.success({dataList});
    }
   
}