/**
 * 企业信息汇总
 * */
 
import { EnterpriseFaRenInfoUpdateConfig, EnterpriseInfomationUpdateConfig, EnterpriseServiceUpdateConfig} from "../config/eccParam/enterprise";
import { OPERATIONALDATATYPE, TABLEID, TABLENAME } from "../config/enum/dbEnum";
import * as enumConfig from "../config/enum/enum";
import { EnterpriseBaseResConfig, EnterpriseFaRenInfoResConfig, EnterpriseInfomationResConfig, EnterpriseLeaseInfoResConfig, EnterpriseQualificationInfoResConfig } from "../config/splitResult/enterprise";
import { operationalData, selectData, selectManyTableData } from "../data/operationalData";
import { BizError } from "../util/bizError";
import { checkChange, extractData } from "../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { eccFormParam } from "../util/verificationParam";
import { ERRORENUM } from "../config/enum/errorEnum";
import { getMySqlMs, getToken, randomId } from "../tools/system";
import moment = require("moment");
import { sendVerificationCode } from "./mail";

//==登录登出

//企业用户表没有存uscc字段，先查询到企业eId，然后到用户表查询密码判断是否登录成功
export async function enterpriseLogin(phone:string, pwd:string) {
    // let dbInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {uscc}, ["eId"]);


    let filesList = ["userName", "eId", "pwd", "uId",  "phone"];
    let includeConf = {};
    includeConf[TABLENAME.企业孵化信息] = {colum:["state", "startTime", "endTime"], where:{state:{"%ne%":enumConfig.FUHUASTATE.迁出}} };
    includeConf[TABLENAME.企业用户表] = {colum:filesList, where:{phone} };
    let enterpriseInfo = await selectManyTableData(OPERATIONALDATATYPE.多表单个, TABLENAME.企业基础信息表, {}, ["enterpriseName"], includeConf);

    if (!enterpriseInfo || !enterpriseInfo.enterpriseName) {
        throw new BizError(ERRORENUM.账号或密码错误);
    }
    let {enterprise_users} = enterpriseInfo;
    let enterpriseUserInfo = enterprise_users[0];
    if (!enterpriseUserInfo || !enterpriseUserInfo.phone) {
        throw new BizError(ERRORENUM.账号或密码错误);
    }
    if (enterpriseUserInfo.pwd != pwd) {
        throw new BizError(ERRORENUM.账号或密码错误);
    }

    let updateUserInfo = {
        token : getToken(enterpriseInfo.uId),
        tokenMs : getMySqlMs()
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, updateUserInfo, {uId:enterpriseUserInfo.uId});
    
    let userInfo = {
        userId:enterpriseUserInfo.uId,
        userName:enterpriseUserInfo.userName,
        phone:enterpriseUserInfo.phone,
        token:updateUserInfo.token,
    };

    return {dataInfo:userInfo};
}


/**
 * 小程序登录改为邮箱认证--todo
 * @param email 邮箱
 * @param code 验证码
 * @returns
 */
export async function enterpriseEmailLogin(email: string, code: string) {

    let filesList = ["userName", "eId", "code", "uId", "email", "codeMs"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, { email }, filesList);

    if (!enterpriseInfo || !enterpriseInfo.eId) {
        throw new BizError(ERRORENUM.账号或密码错误);
    }

    // 检查验证码是否存在
    if (!enterpriseInfo.code || !enterpriseInfo.codeMs) {
        throw new BizError(ERRORENUM.验证码不存在);
    }

    // 获取当前时间戳（毫秒）
    const currentMs = Date.parse(getMySqlMs());
    console.log("currentMs", currentMs);

    // 检查验证码时效（假设5分钟过期）
    if (currentMs - enterpriseInfo.codeMs > 5 * 60 * 1000) {
        throw new BizError(ERRORENUM.验证码过期);
    }

    // 验证码校验
    if (enterpriseInfo.code !== code) {
        throw new BizError(ERRORENUM.code无效);
    }

    let updateUserInfo = {
        token: getToken(enterpriseInfo.uId),
        tokenMs: getMySqlMs()
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, updateUserInfo, { uId: enterpriseInfo.uId });

    let userInfo = {
        userId: enterpriseInfo.uId,
        userName: enterpriseInfo.userName,
        email: enterpriseInfo.email,
        token: updateUserInfo.token,
    };

    return { dataInfo: userInfo };
}

/**
 * 请求发送验证码到指定邮箱
 * @param email 用户邮箱
 * @returns
 */
export async function requestVerificationCode(email: string) {
    try {
        const code = await sendVerificationCode(email);
        console.log(`验证码已发送到邮箱: ${email}, ${code}`);
        // 可以将验证码存储在会话中或前端缓存中，以便后续验证
    } catch (error) {
        console.error('发送验证码失败:', error);
        throw new BizError(ERRORENUM.验证码发送失败);
    }

    return { result: "验证码已发送到邮箱" };
}

export async function enterpriseLogout(uId) {
    let filesList = ["userName", "eId", "pwd", "uId"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业用户表, {uId}, filesList);
    let updateUserInfo = {
        token : getToken(enterpriseInfo.uId),
        tokenMs : getMySqlMs()
    };
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业用户表, updateUserInfo, {uId:enterpriseInfo.uId});

    return {isSuccess:true};

}


/**
 * 登录手机号绑定的其他企业列表
 * @param phone 
 * @returns 
 */
export async function enterpriseByPhone(phone:string) {
    let manyTableInfo:any = {};
    manyTableInfo[TABLENAME.企业基础信息表] = {column: ["enterpriseName", "uscc"], where:{} };

    let filesList = ["userName", "eId"];
    let enterpriseInfo = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业用户表, {phone}, filesList, manyTableInfo);
    
    let dataList = [];
    enterpriseInfo.forEach( info => {
        let {enterprise} = info;

        dataList.push({
            enterpriseName:enterprise.enterpriseName,
            eId:info.eId,
            uscc:enterprise.uscc
        });
    })

    return dataList;

}


//===首页
export async function homePage(eId:string) {
    let filesList = ["enterpriseName", "eId"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);
    let canBaoFileList = ["annual", "zhuanKe", "benKe", "shuoshi", "boShi", "qiTa", "boshiyishang"];
    let canBaoInfo = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.参保记录, {eId}, canBaoFileList);

    canBaoInfo.sort( (a, b) => {return new Date(b.annual).valueOf() - new Date(a.annual).valueOf()});
    
    let chongYeRenYuan = 0;
    if (canBaoInfo[0]) {
        if (canBaoInfo[0].zhuanKe) chongYeRenYuan += canBaoInfo[0].zhuanKe;
        if (canBaoInfo[0].benKe) chongYeRenYuan += canBaoInfo[0].benKe;
        if (canBaoInfo[0].shuoshi) chongYeRenYuan += canBaoInfo[0].shuoshi;
        if (canBaoInfo[0].boShi) chongYeRenYuan += canBaoInfo[0].boShi;
        if (canBaoInfo[0].boshiyishang) chongYeRenYuan += canBaoInfo[0].boshiyishang;
        if (canBaoInfo[0].qiTa) chongYeRenYuan += canBaoInfo[0].qiTa;
    }
    canBaoInfo.sort( (a, b) => {return new Date(b.annual).valueOf() - new Date(a.annual).valueOf()});

    //只返回前五条
    let zhengCeInfo = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.政策表, {}, []);
    
    let zhengCeList = [];
    zhengCeInfo.forEach(info => {
        let {poId, title, source, createTimeMs,closeTimeMs, coverImg,isPermanent} = info;
        let coverImgDefault = JSON.parse(coverImg)[0];
        if (!coverImgDefault) coverImgDefault = "/yuyi/files/默认图片.png";
        // 判断是否为永久有效政策
        let formattedCloseTime = isPermanent == 1 ? "永久有效" : moment(closeTimeMs).format("YYYY-MM-DD");
        if (isPermanent == 1 || (isPermanent == 0 && closeTimeMs > getMySqlMs())) {
            zhengCeList.push( {
                poId,
                title, 
                source, 
                createTimeMs: createTimeMs ? moment(createTimeMs).format("YYYY-MM-DD") : "",
                closeTimeMs:formattedCloseTime, 
                coverImg:coverImgDefault
            });
        }
    })

    zhengCeList = zhengCeList.slice(0, 5);

    let dataInfo = {
        name:enterpriseInfo.enterpriseName,
        chongYeRenYuan,
        zhengCeList:zhengCeList,
        manage:{
            lastYear:{BI:"未填报", TXP:"未填报", RD:"未填报"},
            thisYear:{BI:"未填报", TXP:"未填报", RD:"未填报"}
        }
    }

    let thisYear = new Date().getFullYear();
    let jysjFile = ["BI", "TXP", "RD", "mId","annual","quarter"];

    let thisYearjJysjInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, { eId, state:1, annual:getMySqlMs(`${thisYear}-01-01 00:00:00`)},jysjFile);

    if (thisYearjJysjInfo && thisYearjJysjInfo.mId) {
        dataInfo.manage.thisYear.BI = !isNaN(thisYearjJysjInfo.BI) ? thisYearjJysjInfo.BI : "未填报";
        dataInfo.manage.thisYear.TXP = !isNaN(thisYearjJysjInfo.TXP) ? thisYearjJysjInfo.TXP : "未填报";
        dataInfo.manage.thisYear.RD = !isNaN(thisYearjJysjInfo.RD) ? thisYearjJysjInfo.RD : "未填报";
    }

    let lastYearjJysjInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, { eId, state:1, annual:getMySqlMs(`${thisYear-1}-01-01 00:00:00`)}, jysjFile);
    if (lastYearjJysjInfo && lastYearjJysjInfo.mId) {
        dataInfo.manage.lastYear.BI = !isNaN(lastYearjJysjInfo.BI) ? lastYearjJysjInfo.BI : "未填报";
        dataInfo.manage.lastYear.TXP = !isNaN(lastYearjJysjInfo.TXP) ? lastYearjJysjInfo.TXP : "未填报";
        dataInfo.manage.lastYear.RD = !isNaN(lastYearjJysjInfo.RD) ? lastYearjJysjInfo.RD : "未填报";
    }

    return {
        dataInfo
    }
}


export async function taskList(eId:string, annual, state) {
    let quarterConf = ["第一季度", "第二季度", "第三季度", "第四季度"];
    let year = annual.slice(0, 4);
    let annualquarter = annual.slice(4)
    let quarter = 0;
    quarterConf.forEach( (item, index) => {
        if (annualquarter ==  item) {
            quarter = index + 1;
        }
    })

    let dataList:any[] = [];

    let jysjFile = ["BI", "TXP", "RD", "mId", "state", "isSubmit"];

    let selectParam:any = {eId, annual:getMySqlMs(`${year}-01-01 00:00:00`), quarter};
    if (state == 1 ) selectParam.isSubmit = 0;
    else selectParam.isSubmit = 1;

    let lastYearjJysjInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, { eId, annual:getMySqlMs(`${year}-01-01 00:00:00`), quarter}, jysjFile);
    if (!lastYearjJysjInfo || !lastYearjJysjInfo.mId) {
        //创建新的填报任务
        let itemInfo = {
           eId,
           mId:randomId(TABLEID.企业经营信息),
           annual:getMySqlMs(`${year}-01-01 00:00:00`),
           quarter,
           BI:0,
           TXP:0,
           RD:0,
           createTime:getMySqlMs(),
           state:1,
           isSubmit:0,
           isUpdate:0 
       }
       await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业经营信息, itemInfo, {});
   }

    let manageList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, selectParam, jysjFile);


    // 按年度和季度倒序排列
    manageList.sort((a, b) => {
        if (a.annual === b.annual) {
            return b.quarter - a.quarter;
        }
        return new Date(b.annual).valueOf() - new Date(a.annual).valueOf();
    });

    manageList.forEach(info => {
        dataList.push({
            mId:info.mId,
            annual:moment(info.annual).format("YYYY"),
            quarter: info.quarter,//新增季度
            state:info.isSubmit,
            remaining:!info.isSubmit ? 100:0,
            isSubmit:info.isSubmit == 1
        });
    });
    
    return {
        dataList
    }
}


// export async function taskList(eId:string, annual, state) {
//     let dataList:any[] = [];

//     let thisYear = new Date().getFullYear();

//     let jysjFile = ["BI", "TXP", "RD", "mId", "state", "isSubmit"];
//     let thisYearjJysjInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, {eId, annual:getMySqlMs(`${thisYear}-01-01 00:00:00`)}, jysjFile);
    
//     if (!thisYearjJysjInfo || !thisYearjJysjInfo.mId) {
//         //创建新的填报任务
//         let itemInfo = {
//             eId,
//             mId:randomId(TABLEID.企业经营信息),
//             annual:getMySqlMs(`${thisYear}-01-01 00:00:00`),
//             BI:0,
//             TXP:0,
//             RD:0,
//             createTime:getMySqlMs(),
//             state:0,
//             isSubmit:0,
//             isUpdate:0 
//         }
//         await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业经营信息, itemInfo, {});
//     } 
//     let lastYearjJysjInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, { eId, annual:getMySqlMs(`${thisYear-1}-01-01 00:00:00`)}, jysjFile);
    
//     if (!lastYearjJysjInfo || !lastYearjJysjInfo.mId) {
//          //创建新的填报任务
//          let itemInfo = {
//             eId,
//             mId:randomId(TABLEID.企业经营信息),
//             annual:getMySqlMs(`${thisYear-1}-01-01 00:00:00`),
//             BI:0,
//             TXP:0,
//             RD:0,
//             createTime:getMySqlMs(),
//             state:0,
//             isSubmit:0,
//             isUpdate:0 
//         }
//         await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业经营信息, itemInfo, {});
//     }

   
//     let selectParam:any = {eId, annual:getMySqlMs(`${thisYear}-01-01 00:00:00`)};
//     if (state == 1 ) selectParam.isSubmit = 0;
//     else selectParam.isSubmit = 1;


//     let manageList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, selectParam, jysjFile);
//     manageList.forEach(info => {
//         dataList.push({
//             mId:info.mId,
//             annual:moment(info.annual).format("YYYY"),
//             state:info.isSubmit,
//             remaining:!info.isSubmit ? 100:0,
//             isSubmit:info.isSubmit == 1
//         });
//     });
    
//     return {
//         dataList
//     }
// }

/**
 * 获取企业基本信息
 * 回显
 * @param uscc 
 */
export async function enterpriseBaseInfo(eId) {
    let filesList = ["uscc", "enterpriseName", "logonTime", "logonAddress", "operatingAddress", "oldLogonAddress", "zhuCeHao", "zuZhiJiGouDaiMa", "dengJiJiGuan"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    enterpriseInfo.logonAddress = JSON.parse(enterpriseInfo.logonAddress);
    enterpriseInfo.operatingAddress = enterpriseInfo.operatingAddress || "-";
    enterpriseInfo.oldLogonAddress = JSON.parse(enterpriseInfo.oldLogonAddress||'[]');
    enterpriseInfo.logonTime = moment(enterpriseInfo.logonTime).format("YYYY-MM-DD");
    let dataInfo = extractData(EnterpriseBaseResConfig, enterpriseInfo);

    return {dataInfo};
}

/**
 * 获取企业基本信息
 * 回显
 * @param uscc 
 */
export async function submitTask(eId:string, mId:string) {
    let filesList = ["mId", "isSubmit"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业经营信息, {eId, mId}, filesList);
    if (!resInfo || !resInfo.mId) {
        throw new BizError(ERRORENUM.数据不存在);
    }
    if (resInfo.isSubmit == 1) throw new BizError(ERRORENUM.不可重复提交)
    
    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业经营信息, {isSubmit:1}, {eId, mId});
    return {isSuccess:true};
}



/**
 * 获取企业-我的信息
 * 回显
 * @param uscc 
 */
export async function enterpriseInfomation(eId) {
    let filesList = ["tongXinDiZhi", "industry", "mail", "liaison", "liaisonPhone", "gengDuoDianHua", "jianJie", "mainBusiness"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    enterpriseInfo.industry = JSON.parse(enterpriseInfo.industry || '[]');
    enterpriseInfo.tongXinDiZhi = JSON.parse(enterpriseInfo.tongXinDiZhi);
    let dataInfo = extractData(EnterpriseInfomationResConfig, enterpriseInfo);

    return {dataInfo};
}



/**
 * 修改企业我的信息
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function updateEnterpriseInfomation(eId, param) {
    const FuncName = "企业修改我的信息"
    eccFormParam(FuncName, EnterpriseInfomationUpdateConfig, param );
    eccEnumValue(FuncName, 'industry', enumConfig.INDUSTRY, param.industry);

    let filesList = ["tongXinDiZhi", "industry", "mail", "liaison", "liaisonPhone", "gengDuoDianHua", "jianJie", "mainBusiness"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, filesList);

    param.tongXinDiZhi = JSON.stringify(param.tongXinDiZhi);
    param.industry = JSON.stringify(param.industry); //param.industry[0]; JSON.stringify();
    /**修改字段 */
    let changeList = checkChange(param, enterpriseInfo);
    if ( !changeList.length ) return {isSuccess:true};

    await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.企业基础信息表, param, {eId});
    
    return {isSuccess:true};
}



/**
 * 获取企业-法人信息
 * 回显
 * @param uscc 
 */
export async function enterpriseFaRenInfo(eId) {
    let filesList = ["name", "idCard", "domicile", "degree", "politicalStatus", "phone"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.法人信息表, {eId}, filesList);

    let dataInfo = extractData(EnterpriseFaRenInfoResConfig, enterpriseInfo);

    return {dataInfo};
}



/**
 * 修改企业法人信息
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function updateEnterpriseFaRenInfo(eId, param) {
    const FuncName = "企业修改法人信息"
    eccFormParam(FuncName, EnterpriseFaRenInfoUpdateConfig, param );
    eccEnumValue(FuncName, 'degree', enumConfig.DEGREE, param.degree);
    eccEnumValue(FuncName, 'politicalStatus', enumConfig.ZZMM, param.politicalStatus);

    let filesList = ["name", "idCard", "domicile", "degree", "politicalStatus", "phone"];
    let enterpriseInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.法人信息表, {eId}, filesList);

    /**修改字段 */
    let changeList = checkChange(param, enterpriseInfo);
    if ( !changeList.length ) return {isSuccess:true};

    if (!enterpriseInfo || !enterpriseInfo.name) {
        param.legalId = randomId(TABLEID.法人信息表);
        param.eId = eId;
        await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.法人信息表, param, {});
    } else {
        await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.法人信息表, param, {eId});
    }
    
    return {isSuccess:true};
}


/**
 * 获取企业-入驻信息
 * 回显
 * @param uscc 
 */
export async function enterpriseLeaseInfo(eId) {
    let filesList = ["area", "unitPrice", "startTime", "endTime", "roomNumber", "rent"];
    let includeConf = {};
    includeConf[TABLENAME.租赁信息] = {colum:filesList, where:{} };
    includeConf[TABLENAME.企业孵化信息] = {colum:["state", "startTime", "endTime"], where:{} };
    let enterpriseInfo = await selectManyTableData(OPERATIONALDATATYPE.多表单个, TABLENAME.企业基础信息表, {eId}, ["enterpriseName"], includeConf);
    
    let dataInfo:any = extractData(EnterpriseLeaseInfoResConfig, enterpriseInfo.enterprise_leases[0]);

    dataInfo.enterpriseName = enterpriseInfo.enterpriseName;
    dataInfo.state = changeEnumValue(enumConfig.FUHUASTATE, enterpriseInfo.enterprise_fuhuas[0].state);

    //如果 startTime 或 endTime 为空或无效，可以设置默认值或提示信息：
    if (enterpriseInfo.enterprise_leases) {
        const startTime = moment(enterpriseInfo.enterprise_leases[0].startTime);
        const endTime = moment(enterpriseInfo.enterprise_leases[0].endTime);
    
        if (startTime.isValid() && endTime.isValid()) {
            dataInfo.leaseTime = `${startTime.format("YYYY-MM-DD")}至${endTime.format("YYYY-MM-DD")}`;
        } else {
            dataInfo.leaseTime = '未设置租赁日期';
        }
    } else {
        dataInfo.leaseTime = '无租赁信息';
    }
    // if (enterpriseInfo.enterprise_leases) dataInfo.leaseTime = `${moment(enterpriseInfo.enterprise_leases[0].startTime).format("YYYY-MM-DD")}至${moment(enterpriseInfo.enterprise_leases[0].endTime).format("YYYY-MM-DD")}`;
    if (enterpriseInfo.enterprise_fuhuas) dataInfo.fuHuaTime = `${moment(enterpriseInfo.enterprise_fuhuas[0].startTime).format("YYYY-MM-DD")}至${moment(enterpriseInfo.enterprise_fuhuas[0].endTime).format("YYYY-MM-DD")}`;
    

    return {dataInfo};
}

//===============================================企业服务


/**
 * 企业服务-列表
 * 回显
 * @param uscc 
 */
export async function enterpriseServiceList(eId) { 
    let filesList = ["esId", "needCategory", "applyTime", "followUpStatus"];

    let iprList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业服务表, {eId}, filesList);

    let dataList:any[] = [];
    iprList.forEach(item => {
        let {esId, needCategory, applyTime, followUpStatus} = item;

        dataList.push({
            esId,
            needCategory,
            applyTime:moment(applyTime).format("YYYY-MM-DD"),
            followUpStatus:changeEnumValue(enumConfig.FOLLOWUPSTATUS, followUpStatus)
        });
    });

    return {dataList};
}


/**
 * 企业服务-回显
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function enterpriseServiceInfo(eId, esId) {

    let filesList = [ "esId", "needCategory", "applyTime", "followUpStatus", "needContent", "fangKui", "outcome", "desc"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, {esId, eId}, filesList)
    if (!resInfo || !resInfo.esId) throw new BizError(ERRORENUM.当前数据不存在);

    let dataInfo = {
        esId:resInfo.esId,
        needCategory:resInfo.needCategory,
        applyTime:moment(resInfo.applyTime).format("YYYY-MM-DD"),
        followUpStatus:changeEnumValue(enumConfig.FOLLOWUPSTATUS, resInfo.followUpStatus),
        needContent:resInfo.needContent,
        dealResult:resInfo.fangKui,
    }
    if(resInfo.followUpStatus == enumConfig.FOLLOWUPSTATUS.已完成) {
        dataInfo.dealResult = `已处理${resInfo.outcome ? "已解决" : "未解决"}`;
        console.log("dealResult", dataInfo.dealResult);
        if (resInfo.desc) dataInfo.dealResult += `，${resInfo.desc}`;
    }
    
    return {dataInfo};
}


/**
 * 企业服务-添加
 * @param uscc 企业统一信用代码
 * @param param 表单
 * @returns 
 */
export async function createEnterpriseServiceInfo(eId, param) {
    const FuncName = "企业添加企业服务"
    eccFormParam(FuncName, EnterpriseServiceUpdateConfig, param );

    let addInfo = {
        esId:randomId(TABLEID.企业服务表),
        eId,
        needCategory:param.needCategory,
        needContent:param.needContent,
        applyTime:getMySqlMs(),
        followUpStatus:enumConfig.FOLLOWUPSTATUS.未受理
    };

    await operationalData(OPERATIONALDATATYPE.增加, TABLENAME.企业服务表, addInfo, {});
    
    return {isSuccess:true};
}


/**
 * 企业服务-删除
 * @param param0 
 * @returns 
 */
export async function deleteEnterpriseServiceInfo(eId, esId) {
    let filesList = ["esId", "needCategory", "applyTime", "followUpStatus", "needContent"];
    let iprInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业服务表, {esId, eId}, filesList)
    if (!iprInfo || !iprInfo.esId) throw new BizError(ERRORENUM.当前数据不存在);

    await operationalData(OPERATIONALDATATYPE.删除, TABLENAME.企业服务表, {}, {esId, eId});
    
    return {isSuccess:true};
}


//===========================================政策速递

/**
 * 
 * @param state 
 * @returns 
 */
export async function enterprisePolicyList(state) {
    let filesList = ["poId", "title", "source", "createTimeMs", "closeTimeMs", "coverImg","isPermanent"];
    let resList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.政策表, {}, filesList);

    let dataList = [];
    resList.forEach(info => {
        let { poId, title, source,createTimeMs, closeTimeMs, coverImg, isPermanent } = info;
        // 判断是否为永久有效政策
        let formattedCreateTime = "-";
        if (isPermanent == 1) formattedCreateTime = "永久有效";
        else formattedCreateTime = moment(closeTimeMs).format("YYYY-MM-DD");

        if (state == 1) {
            if (isPermanent == 1 || closeTimeMs > getMySqlMs()) {
                dataList.push( {
                    poId,
                    title, 
                    source,
                    createTimeMs:createTimeMs ? moment(createTimeMs).format("YYYY-MM-DD") : "",
                    closeTimeMs:formattedCreateTime, 
                    coverImg:coverImg ? JSON.parse(coverImg)[0] :'',
                    isPermanent
                });
            }
        } else if (state == 2) {
            if (isPermanent == 0 && getMySqlMs() > closeTimeMs) {
                dataList.push( {
                    poId,
                    title, 
                    source,
                    createTimeMs:createTimeMs ? moment(createTimeMs).format("YYYY-MM-DD") : "",
                    closeTimeMs:formattedCreateTime, 
                    coverImg:coverImg ? JSON.parse(coverImg)[0] :'',
                    isPermanent
                } );
            }
        }
        
    });

    return {dataList};
}



export async function enterprisePolicyInfo(poId) {
    let filesList = ["poId", "desc", "title", "source", "closeTimeMs", "coverImg","isPermanent", "createTimeMs"];
    let resInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.政策表, {poId}, filesList);
    if (!resInfo || !resInfo.poId) {
        throw new BizError(ERRORENUM.数据不存在);
    }

    let {closeTimeMs, isPermanent } = resInfo;

    // 判断是否为永久有效政策
    let formattedCreateTime = isPermanent ? "永久有效" :  moment(closeTimeMs).format("YYYY-MM-DD");

    let dataInfo = {
        poId:resInfo.poId, 
        desc:resInfo.desc, 
        title:resInfo.title,
        source:resInfo.source, 
        closeTimeMs: formattedCreateTime, 
        coverImg:JSON.parse(resInfo.coverImg),
        // createTimeMs:moment(closeTimeMs).format("YYYY-MM-DD")
    }


    return {dataInfo};
}



