"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.changeEnumValue = exports.eccEnumValue = void 0;
const errorEnum_1 = require("../config/errorEnum");
const bizError_1 = require("../util/bizError");
/**
 * 校验value是否符合传入的枚举
 * @param name 被掉用名称 用于输出异常日志
 * @param key 目标字段  用于输出异常日志
 * @param enumConf 目标枚举
 * @param value 目标值
 * 无返回 有异常直接报错
 */
function eccEnumValue(name, key, enumConf, value) {
    let eccSuccess = true;
    if (typeof value == 'number') {
        if (!enumConf[value])
            eccSuccess = false;
    }
    else if (Array.isArray(value)) {
        value.forEach(item => {
            if (!enumConf[item])
                eccSuccess = false;
        });
    }
    if (!eccSuccess)
        throw new bizError_1.BizError(errorEnum_1.ERRORENUM.请完善信息, `${name} 下的 ${key} 字段值为 ${value} 不满足枚举范围`);
}
exports.eccEnumValue = eccEnumValue;
/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
function changeEnumValue(enumConf, value) {
    if (!value)
        return '';
    if (typeof value == 'number') {
        let str = enumConf[value];
        /**特化处理 */
        if (/_dou/.test(str))
            str = str.replace(/_dou/gm, "，");
        if (/_zyh/.test(str))
            str = str.replace(/_zyh/gm, "“");
        if (/_yyh/.test(str))
            str = str.replace(/_yyh/gm, "”");
        if (/_dun/.test(str))
            str = str.replace(/_dun/gm, "、");
        if (/_ju/.test(str))
            str = str.replace(/_ju/gm, "。");
        return str;
    }
    else if (typeof value == 'string') {
        try { //兼容数据库  '[1,2,3]'
            value = JSON.parse(value);
        }
        catch (err) {
            return enumConf[parseInt(value)];
        }
    }
    let str = "";
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        /**特化处理 */
        if (/_dou/.test(subStr))
            subStr = subStr.replace(/_dou/gm, "，");
        if (/_zyh/.test(subStr))
            subStr = subStr.replace(/_zyh/gm, "“");
        if (/_yyh/.test(subStr))
            subStr = subStr.replace(/_yyh/gm, "”");
        if (/_dun/.test(subStr))
            subStr = subStr.replace(/_dun/gm, "、");
        if (/_ju/.test(subStr))
            subStr = subStr.replace(/_ju/gm, "。");
        str += subStr;
        if (index == value.length - 1)
            str += "";
        else
            str += ",";
    });
    return str;
}
exports.changeEnumValue = changeEnumValue;
//# sourceMappingURL=eccEnum.js.map