"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function qyfwInterfaceData() {
    let qyfwinterfaceName = "企业服务";
    let qyfwData = cronJob_1.getInterfaceByInterfaceName(qyfwinterfaceName);
    /*
     qyjbqk = 企业基本情况 ;
     bhqsfxzf = 变化趋势分析在孵 ;
     bhqsfxby = 变化趋势分析毕业 ;
     rfszfb = 入孵时长分布 ;
     fhqyhylyzb = 孵化企业行业领域占比 ;
     qyrcjyrs = 企业人才就业人数 ;
     qyrccytdfb = 企业人才创业团队分布 ;
     qyfwhzsj = 企业服务汇总数据 ;
     qyxqdt = 企业需求动态 ;
     qyxqdtxx = 企业需求动态详细 ;
     dt = 地图 ;
     qybhqk = 企业变化情况 ;
     bhqsqys = 变化趋势企业数 ;
     jrfw = 金融服务 ;
     byrzqyrzqy = 本月融资企业融资企业 ;
     byrzjerzje = 本月融资金额融资金额 ;
     zfqyzys = 在孵企业总营收 ;
     jrfwqy = 金融服务企业 ;
     zscq = 知识产权 ;
     zscqbt = 知识产权饼图 ;
     zscqxq = 知识产权详情 ;
     qyzzfl = 企业资质分类 ;
     qyzzfl-xjr = 企业资质分类-小巨人 ;
     qyzzfl-gxqy = 企业资质分类-高新企业 ;
     qyzzfl-zjtx = 企业资质分类-专精特新 ;
     qyzzfl-gqpy = 企业资质分类-高企培育 ;
    
    */
    let config = { "qyjbqk": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "bhqsfxzf": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "bhqsfxby": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "rfszfb": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "fhqyhylyzb": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyrcjyrs": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyrccytdfb": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyfwhzsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyxqdt": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyxqdtxx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "dt": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qybhqk": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "bhqsqys": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "jrfw": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "byrzqyrzqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "byrzjerzje": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "zfqyzys": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "jrfwqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "zscq": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zscqbt": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "zscqxq": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyzzfl": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyzzfl-xjr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyzzfl-gxqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyzzfl-zjtx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "qyzzfl-gqpy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, qyfwData);
    let changeData = changeDataProcess('企业服务', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=qyfwData.js.map