"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TablesConfig = void 0;
const Sequelize = require('sequelize');
exports.TablesConfig = [
    {
        tableNameCn: '支部表',
        tableName: 'branch',
        schema: {
            bId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            branchName: { type: Sequelize.STRING(100), allowNull: false }, //支部名称
        },
        association: []
    },
    {
        tableNameCn: '后台用户表',
        tableName: 'adminUser',
        schema: {
            uId: {
                type: Sequelize.STRING(100),
                allowNull: false,
                primaryKey: true,
                unique: true //表示该列的值必须唯一
            },
            loginId: { type: Sequelize.STRING(100), allowNull: false },
            pwd: { type: Sequelize.STRING(100), allowNull: false },
            token: { type: Sequelize.STRING(100), allowNull: true },
            tokenMs: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW }
        },
        association: []
    },
    {
        tableNameCn: '党员基础信息表',
        tableName: 'partyMember',
        schema: {
            pmId: {
                type: Sequelize.STRING(100),
                allowNull: false,
                primaryKey: true,
                unique: true //表示该列的值必须唯一
            },
            etId: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 1 },
            name: { type: Sequelize.STRING(100), allowNull: false },
            sex: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 1 },
            birthDate: { type: Sequelize.DATE, allowNull: false },
            phone: { type: Sequelize.STRING(11), allowNull: false },
            levelOfEducation: { type: Sequelize.INTEGER, allowNull: false },
            bId: { type: Sequelize.INTEGER(20), allowNull: false },
            partyJoiningTime: { type: Sequelize.DATE, allowNull: true },
            administrativePositionName: { type: Sequelize.INTEGER, allowNull: true, defaultValue: 1 },
            partyPositionsName: { type: Sequelize.STRING(100), allowNull: true, defaultValue: '[]' },
            departmentName: { type: Sequelize.STRING(100), allowNull: true, defaultValue: '[]' },
            askForTime: { type: Sequelize.DATE, allowNull: true },
            listedAsActivistsTime: { type: Sequelize.DATE, allowNull: true },
            liaison: { type: Sequelize.STRING(100), allowNull: true, defaultValue: '[]' },
            talkTime: { type: Sequelize.DATE, allowNull: true },
            partyState: { type: Sequelize.INTEGER, allowNull: true, defaultValue: 1 },
            isAdmin: { type: Sequelize.BOOLEAN, allowNull: true, defaultValue: false },
            /**小程序登录 */
            loginId: { type: Sequelize.STRING(11), allowNull: false },
            pwd: { type: Sequelize.STRING(100), allowNull: false },
            token: { type: Sequelize.STRING(100), allowNull: true },
            tokenMs: { type: Sequelize.DATE, allowNull: true },
            adminToken: { type: Sequelize.STRING(100), allowNull: true },
            adminTokenMs: { type: Sequelize.DATE, allowNull: true },
        },
        association: [
            { type: "hasMany", check: "partyExpenses", foreignKey: "pmId" },
            { type: "hasMany", check: "rateLearning", foreignKey: "pmId" },
            { type: "hasMany", check: "learningPower", foreignKey: "pmId" },
        ]
    },
    {
        tableNameCn: '支部制度表',
        tableName: 'branchSystem',
        schema: {
            bsId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            systemTitle: { type: Sequelize.STRING(500), allowNull: false },
            bId: { type: Sequelize.STRING(100), allowNull: false, defaultValue: '[]' },
            releaseTime: { type: Sequelize.DATE, allowNull: false },
            isUse: { type: Sequelize.BOOLEAN, allowNull: false, defaultValue: true },
            fileName: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' },
            fileType: { type: Sequelize.INTEGER, allowNull: true },
            uploadTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW }, //上传时间
        },
        association: []
    },
    {
        tableNameCn: '组织生活表',
        tableName: 'organizationalLife',
        schema: {
            oId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            theme: { type: Sequelize.STRING(500), allowNull: false },
            themeType: { type: Sequelize.INTEGER, allowNull: false },
            dataMonth: { type: Sequelize.DATE, allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            fileName: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' },
            fileType: { type: Sequelize.INTEGER, allowNull: true },
            uploadTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW }, //上传时间
        },
        association: []
    },
    {
        tableNameCn: '专题活动表',
        tableName: 'thematicActivities',
        schema: {
            taId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            theme: { type: Sequelize.STRING(500), allowNull: false },
            dataMonth: { type: Sequelize.DATE, allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            fileName: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' },
            fileType: { type: Sequelize.INTEGER, allowNull: true },
            uploadTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW }, //上传时间
        },
        association: []
    },
    {
        tableNameCn: '党建动态表',
        tableName: 'partyBuildingDynamic',
        schema: {
            pbId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            theme: { type: Sequelize.STRING(500), allowNull: false },
            dataMonth: { type: Sequelize.DATE, allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            fileName: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' },
            fileType: { type: Sequelize.INTEGER, allowNull: true },
            uploadTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW }, //上传时间
        },
        association: []
    },
    {
        tableNameCn: '党费管理表',
        tableName: 'partyExpenses',
        schema: {
            peId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            pmId: { type: Sequelize.STRING(100), allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            payType: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 2 },
            payableMonth: { type: Sequelize.DATE, allowNull: false },
            payTime: { type: Sequelize.DATE, allowNull: true },
            payAmount: { type: Sequelize.INTEGER, allowNull: true }, //缴费金额（元）
        },
        association: []
    },
    {
        tableNameCn: '党建先锋表',
        tableName: 'partyVanguard',
        schema: {
            pvId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            honorName: { type: Sequelize.STRING(500), allowNull: false },
            honorType: { type: Sequelize.INTEGER, allowNull: false },
            grantingRange: { type: Sequelize.INTEGER, allowNull: false },
            grantingUnit: { type: Sequelize.STRING(100), allowNull: false },
            grantTime: { type: Sequelize.DATE, allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            isUse: { type: Sequelize.BOOLEAN, allowNull: false, defaultValue: true }, //是否使用
        },
        association: []
    },
    {
        tableNameCn: '党员学习表',
        tableName: 'memberLearning',
        schema: {
            mlId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            contentTitle: { type: Sequelize.STRING(500), allowNull: false },
            courseTypeName: { type: Sequelize.INTEGER, allowNull: false },
            courseEntryType: { type: Sequelize.INTEGER, allowNull: false },
            hits: { type: Sequelize.INTEGER, allowNull: false },
            coverImage: { type: Sequelize.STRING(500), allowNull: true, defaultValue: 'defalitImage.png' },
            videoDuration: { type: Sequelize.STRING(500), allowNull: true },
            isUse: { type: Sequelize.BOOLEAN, allowNull: false, defaultValue: true },
            fileName: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' },
            fileType: { type: Sequelize.INTEGER, allowNull: true },
            uploadTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW },
            updateTime: { type: Sequelize.DATE, allowNull: true, defaultValue: Sequelize.NOW },
            isDelete: { type: Sequelize.BOOLEAN, allowNull: false, defaultValue: false }, //是否删除
        },
        association: [
            { type: "hasMany", check: "rateLearning", foreignKey: "mlId" },
        ]
    },
    {
        tableNameCn: '学习进度表',
        tableName: 'rateLearning',
        schema: {
            rlId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            pmId: { type: Sequelize.STRING(100), allowNull: false },
            mlId: { type: Sequelize.INTEGER, allowNull: false },
            rateOfLearning: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 0 },
            learningCompleted: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 1 },
            textSchedule: { type: Sequelize.STRING(500), allowNull: true, defaultValue: '[]' }, //文字学习进度 已读文件的json格式
        },
        association: []
    },
    {
        tableNameCn: '学习强国',
        tableName: 'learningPower',
        schema: {
            lpId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            pmId: { type: Sequelize.STRING(100), allowNull: false },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            dayIntegral: { type: Sequelize.INTEGER, allowNull: false },
            totalIntegral: { type: Sequelize.INTEGER, allowNull: false },
            dataYear: { type: Sequelize.STRING(100), allowNull: false },
            dataMonth: { type: Sequelize.STRING(100), allowNull: false },
            dataDay: { type: Sequelize.STRING(100), allowNull: false },
            dataTime: { type: Sequelize.DATE, allowNull: false }, //数据时间
        },
        association: []
    },
    {
        tableNameCn: '三级指标',
        tableName: 'thirdLevel',
        schema: {
            tlId: {
                type: Sequelize.INTEGER(20),
                allowNull: false,
                primaryKey: true,
                autoIncrement: true,
                unique: true //表示该列的值必须唯一
            },
            bId: { type: Sequelize.INTEGER, allowNull: false },
            primaryIndicators: { type: Sequelize.INTEGER, allowNull: false },
            secondaryIndicators: { type: Sequelize.INTEGER, allowNull: false },
            thirdLevelScore: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 0 },
            thirdLevelContent: { type: Sequelize.STRING(500), allowNull: false, defaultValue: '' },
            currentScore: { type: Sequelize.INTEGER, allowNull: false, defaultValue: 0 },
            completionProgress: { type: Sequelize.INTEGER, allowNull: false },
            weight: { type: Sequelize.INTEGER, allowNull: false },
            dataYear: { type: Sequelize.INTEGER, allowNull: false },
            lock: { type: Sequelize.BOOLEAN, allowNull: false, defaultValue: false }, //锁，上了之后不可编辑内容
        },
        association: []
    }
];
//# sourceMappingURL=mysqlTableConfig.js.map