"use strict";
/**
 * 日志类
 * 包括错误日志 普通日志
 * 日志存放在根目录的logs内
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.logConsole = exports.logHandle = exports.logError = exports.systemLogPath = void 0;
let log4js = require('log4js');
let path = require('path');
//log路径
exports.systemLogPath = {
    errorLogFile: "error",
    errorLogDir: "error",
    handleLogFile: "handle",
    handleLogDir: "handle"
};
//日志根目录
// let baseLogPath = path.resolve(__dirname.substring(0, __dirname.indexOf("out")), 'logs');
let baseLogPath = path.resolve('./', 'logs');
let errFile = path.resolve(baseLogPath, exports.systemLogPath.errorLogDir, exports.systemLogPath.errorLogFile);
let handFile = path.resolve(baseLogPath, exports.systemLogPath.handleLogDir, exports.systemLogPath.handleLogFile);
let config = {
    appenders: {
        "rule-console": { "type": "console" },
        "errorLogger": {
            "type": "dateFile",
            "filename": errFile,
            "pattern": "yyyy-MM-dd.log",
            "alwaysIncludePattern": true,
            "encoding": "utf-8",
            "maxLogSize": 1000,
            "numBackups": 3,
            "path": `/${exports.systemLogPath.errorLogDir}`
        },
        "handleLogger": {
            "type": "dateFile",
            "filename": handFile,
            "pattern": "yyyy-MM-dd.log",
            "alwaysIncludePattern": true,
            "encoding": "utf-8",
            "maxLogSize": 1000,
            "numBackups": 3,
            "path": `/${exports.systemLogPath.handleLogDir}`
        }
    },
    categories: {
        "default": { "appenders": ["rule-console"], "level": "all" },
        "errorLogger": { "appenders": ["errorLogger"], "level": "error" },
        "handleLogger": { "appenders": ["handleLogger"], "level": "all" }
    },
    "baseLogPath": path.resolve(baseLogPath, exports.systemLogPath.handleLogDir, exports.systemLogPath.handleLogFile)
};
log4js.configure(config); //加载配置文件
//调用预先定义的日志名称
let errorLogger = log4js.getLogger("errorLogger");
let handleLogger = log4js.getLogger("handleLogger");
let consoleLogger = log4js.getLogger("rule-console");
//错误日志
function logError(...errStrs) {
    let str = "";
    errStrs.forEach(item => {
        str += item + " |  ";
    });
    errorLogger.error(`errorInfo =>   ${str}`);
}
exports.logError = logError;
//普通日志
function logHandle(msgStr) {
    handleLogger.info(`logInfo =>    ${msgStr}`);
}
exports.logHandle = logHandle;
//输出日志
function logConsole(logStr) {
    consoleLogger.info(`logInfo =>   ${logStr}`);
}
exports.logConsole = logConsole;
//# sourceMappingURL=log.js.map