"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interfaceAnalysis_1 = require("../../dataPackage/interfaceAnalysis");
const bizError_1 = require("../../util/bizError");
const cronJob_1 = require("./cronJob");
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);
        if ((type == "array" && !dataIsArray) || (type == "object" && dataIsArray) ||
            (type == "object" && fileType != "object") || (type != "array" && fileType != type)) {
            throw new bizError_1.BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }
        let onceData;
        switch (operationsType) {
            case "object_ToList":
                onceData = interfaceAnalysis_1.changeObjectToList(fileData, reflect);
                break;
            case "object_changeKey":
                onceData = interfaceAnalysis_1.changeObjectKey(fileData, reflect);
                break;
            case "list_changeKey":
                onceData = interfaceAnalysis_1.changeListObjectToListByReflect(fileData, reflect);
                break;
        }
        if (unitInfo)
            onceData = interfaceAnalysis_1.designativListKeyAddUnit(onceData, unitInfo);
        result[dataName] = onceData;
    }
    return result;
}
function zhyyInterfaceData() {
    let zhyyinterfaceName = "智慧运营";
    let zhyyData = cronJob_1.getInterfaceByInterfaceName(zhyyinterfaceName);
    /*
     yqgk = 园区概况 ;
     zfqysj = 在孵企业数据 ;
     rzqybhqsrzqys = 入驻企业变化趋势入驻企业数 ;
     rzqyhylx = 入驻企业行业类型 ;
     fhyy = 孵化运营 ;
     fhmjbhqsfhmj = 孵化面积变化趋势孵化面积 ;
     zfqybhqszfqy = 在孵企业变化趋势在孵企业 ;
     byqybhqsbyqy = 毕业企业变化趋势毕业企业 ;
     rzqybhqsrzqy = 融资企业变化趋势融资企业 ;
     ryzz = 荣誉资质 ;
     zhyyhzsj = 智慧运营汇总数据 ;
     dt = 地图 ;
     jyfx = 就业分析 ;
     jdjyrsqsfxjyrs = 季度就业人数趋势分析就业人数 ;
     cygmfx = 产业规模分析 ;
     zfqyyszb = 在孵企业营收占比 ;
     qyfw = 企业服务 ;
     qyfwlx = 企业服务类型 ;
     fwzl = 服务质量 ;
     yysrqsczbt = 运营收入趋势财政补贴 ;
     yysrqsfwsr = 运营收入趋势服务收入 ;
     yysrqsfzsr = 运营收入趋势房租收入 ;
     yysrqstzsr = 运营收入趋势投资收入 ;
     cyzc = 产业政策 ;
     cyzcxx = 产业政策详细 ;
     yqhd = 园区活动 ;
     yqxw = 园区新闻 ;
    
    */
    let config = { "yqgk": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zfqysj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "rzqybhqsrzqys": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "rzqyhylx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fhyy": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "fhmjbhqsfhmj": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "zfqybhqszfqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "byqybhqsbyqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "rzqybhqsrzqy": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "ryzz": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zhyyhzsj": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "dt": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "jyfx": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "jdjyrsqsfxjyrs": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "cygmfx": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "zfqyyszb": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyfw": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "qyfwlx": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "fwzl": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "yysrqsczbt": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "yysrqsfwsr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "yysrqsfzsr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "yysrqstzsr": { "type": "array", "operationsType": "list_changeKey", "reflect": "", "unitInfo": {} }, "cyzc": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "cyzcxx": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yqhd": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} }, "yqxw": { "type": "object", "operationsType": "object_ToList", "reflect": "", "unitInfo": {} } };
    let interfaceData = Object.assign({}, zhyyData);
    let changeData = changeDataProcess('智慧运营', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了
}
//# sourceMappingURL=zhyyData.js.map