"use strict";
/**
 * 异常类
 * 需要和log4js共同使用
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.BizError = void 0;
const errorEnum_1 = require("../config/errorEnum");
const log_1 = require("./log");
class BizError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i < msgs.length; i++) {
            if (!i) {
                let msg = errorEnum_1.getBizMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            }
            else {
                logErrorMsg += ` | ${msgs[i]} `;
            }
        }
        log_1.logError(logErrorMsg);
        super(reqErrorMsg);
    }
}
exports.BizError = BizError;
//# sourceMappingURL=bizError.js.map