"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const qyszhxData_1 = require("../data/table/qyszhxData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
const serverConfig_1 = require("../config/serverConfig");
/*                            企业数字画像                    */
function getData(req, res) {
    let excelData = qyszhxData_1.qyszhxTableData();
    let ret = {};
    let qyjbqkPackageData = inFrontOut_1.keyValuePackage(excelData['企业基本情况'].dataList);
    let qyjbqk = [];
    qyjbqkPackageData.forEach(info => {
        let { key, value } = info;
        if (key == "企业图片") {
            info.value = `${serverConfig_1.systemConfig.imgPath}/${value}`;
        }
        qyjbqk.push(info);
    });
    ret['qyjbqk'] = out_1.getKeyValueOut('企业基本情况', qyjbqk);
    let qyjbsjPackageData = inFrontOut_1.keyValuePackage(excelData['企业基本数据'].dataList, "false");
    ret['qyjbsj'] = out_1.getKeyValueOut('企业基本数据', qyjbsjPackageData);
    let qybqPackageData = inFrontOut_1.stringListPackage(excelData['企业标签'].dataList);
    ret['qybq'] = out_1.getStringOut('企业标签', qybqPackageData);
    let zscqPackageData = inFrontOut_1.keyValuePackage(excelData['知识产权'].dataList);
    ret['zscq'] = out_1.getKeyValueOut('知识产权', zscqPackageData);
    let qyyghxPackageData = inFrontOut_1.keyValuePackage(excelData['企业员工画像'].dataList);
    ret['qyyghx'] = out_1.getKeyValueOut('企业员工画像', qyyghxPackageData);
    let lnrczpqkPackageData = inFrontOut_1.onceYBarChartPackage(excelData['历年人才招聘情况'], '', '');
    ret['lnrczpqk'] = out_1.getOnceYBarChartOut('历年人才招聘情况', lnrczpqkPackageData);
    let qyhzsjPackageData = inFrontOut_1.keyValuePackage(excelData['企业汇总数据'].dataList);
    ret['qyhzsj'] = out_1.getKeyValueOut('企业汇总数据', qyhzsjPackageData);
    let xjrTableData = inFrontOut_1.tablePackage(excelData["小巨人"].headerList[0], excelData["小巨人"].bodyList);
    ret['xjr'] = out_1.getTableOut('小巨人', xjrTableData);
    let gxqyTableData = inFrontOut_1.tablePackage(excelData["高新企业"].headerList[0], excelData["高新企业"].bodyList);
    ret['gxqy'] = out_1.getTableOut('高新企业', gxqyTableData);
    let zjtxTableData = inFrontOut_1.tablePackage(excelData["专精特新"].headerList[0], excelData["专精特新"].bodyList);
    ret['zjtx'] = out_1.getTableOut('专精特新', zjtxTableData);
    let ysqkPackageData = inFrontOut_1.keyValuePackage(excelData['营收情况'].dataList);
    ret['ysqk'] = out_1.getKeyValueOut('营收情况', ysqkPackageData);
    let ysbhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['营收变化趋势'], '', '');
    ret['ysbhqs'] = out_1.getOnceYBarChartOut('营收变化趋势', ysbhqsPackageData);
    let qydtTableData = inFrontOut_1.tablePackage(excelData["企业动态"].headerList[0], excelData["企业动态"].bodyList);
    let qydt = { dataList: [], titleList: qydtTableData.titleList };
    qydtTableData.dataList.forEach(info => {
        let { A } = info;
        let imgUrl = `${serverConfig_1.systemConfig.imgPath}/${A}`;
        info["A"] = imgUrl;
        qydt.dataList.push(info);
    });
    ret['qydt'] = out_1.getTableOut('企业动态', qydt);
    let fwxqPackageData = inFrontOut_1.keyValuePackage(excelData['服务需求'].dataList, "false");
    ret['fwxq'] = out_1.getKeyValueOut('服务需求', fwxqPackageData);
    let hdbhqsfxPackageData = inFrontOut_1.onceYBarChartPackage(excelData['活动变化趋势分析'], '', '');
    ret['hdbhqsfx'] = out_1.getOnceYBarChartOut('活动变化趋势分析', hdbhqsfxPackageData);
    let fwjl_kjfwTableData = inFrontOut_1.tablePackage(excelData["服务记录_空间服务"].headerList[0], excelData["服务记录_空间服务"].bodyList);
    ret['fwjl_kjfw'] = out_1.getTableOut('服务记录_空间服务', fwjl_kjfwTableData);
    let fwjl_gsfwTableData = inFrontOut_1.tablePackage(excelData["服务记录_工商服务"].headerList[0], excelData["服务记录_工商服务"].bodyList);
    ret['fwjl_gsfw'] = out_1.getTableOut('服务记录_工商服务', fwjl_gsfwTableData);
    let fwjl_rzfwTableData = inFrontOut_1.tablePackage(excelData["服务记录_融资服务"].headerList[0], excelData["服务记录_融资服务"].bodyList);
    ret['fwjl_rzfw'] = out_1.getTableOut('服务记录_融资服务', fwjl_rzfwTableData);
    let fwjlPackageData = inFrontOut_1.keyValuePackage(excelData['服务记录'].dataList);
    ret['fwjl'] = out_1.getKeyValueOut('服务记录', fwjlPackageData);
    let yqtzPackageData = inFrontOut_1.keyValuePackage(excelData['园区通知'].dataList);
    ret['yqtz'] = out_1.getKeyValueOut('园区通知', yqtzPackageData);
    let yqtzxqTableData = inFrontOut_1.tablePackage(excelData["园区通知详情"].headerList[0], excelData["园区通知详情"].bodyList);
    let yqtzxq = { dataList: [], titleList: yqtzxqTableData.titleList };
    yqtzxqTableData.dataList.forEach(info => {
        let { A } = info;
        let imgUrl = `${serverConfig_1.systemConfig.imgPath}/${A}`;
        info["A"] = imgUrl;
        yqtzxq.dataList.push(info);
    });
    ret['yqtzxq'] = out_1.getTableOut('园区通知详情', yqtzxq);
    let yqhdPackageData = inFrontOut_1.keyValuePackage(excelData['园区活动'].dataList);
    ret['yqhd'] = out_1.getKeyValueOut('园区活动', yqhdPackageData);
    let yqhdmxTableData = inFrontOut_1.tablePackage(excelData["园区活动明细"].headerList[0], excelData["园区活动明细"].bodyList);
    ret['yqhdmx'] = out_1.getTableOut('园区活动明细', yqhdmxTableData);
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=qyszhx.js.map