
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function jxgljscTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('yuyiServer.xlsx', '绩效管理驾驶舱');

    let keyValueOrTitleList = ["在孵企业面积情况分析","产业结构","人才引进","孵化器汇总数据","新增在孵企业情况","资源集聚能力","综合能力","毕业企业情况","区域创新辐射带动能力","预警","企业预警","企业动态","金融服务","总营收金额","在孵企业总营收","投资类型","在孵企业融资情况","公共技术服务","企业孵化率","企业孵化数"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["在孵企业面积变化趋势","在孵企业变化趋势"]; //适配 柱状图 折线图 ,"投资类型"
    let stringList = [];
    let decollatePlanarList =["硬科技企业培育情况"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}