
import { changeListObjectToListByReflect, changeObjectKey, changeObjectToList, designativListKeyAddUnit, getDesignativByReflect } from "../../dataPackage/interfaceAnalysis";
import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

        
function changeDataProcess(interfaceName, interfaceData, config) {
    let result = {};
    for (let dataName in config) {
        let { type, operationsType, reflect, unitInfo } = config[dataName];
        let fileData = interfaceData[dataName];
        let fileType = typeof fileData;
        let dataIsArray = Array.isArray(fileData);

        if ( (type == "array" && !dataIsArray) || (type == "object" && dataIsArray) || 
            (type == "object" && fileType != "object") || (type != "array" && fileType != type) ) {
            throw new BizError(`接口 ${interfaceName}中的${dataName}类型错误应该为 ${type} 现在为${fileType}`);
        }

        let onceData;
        switch (operationsType) {
            case "object_ToList": onceData= changeObjectToList(fileData, reflect); break;
            case "object_changeKey": onceData = changeObjectKey(fileData, reflect); break;
            case "list_changeKey": onceData = changeListObjectToListByReflect(fileData, reflect); break;
        }

        if (unitInfo) onceData = designativListKeyAddUnit(onceData, unitInfo);

        result[dataName] = onceData;
    }

    return result;
}


function jxgljscInterfaceData() {
    
    let jxgljscinterfaceName = "绩效管理驾驶舱";
    let jxgljscData:any = getInterfaceByInterfaceName(jxgljscinterfaceName);
            
    /*
     zfqymjqkfx = 在孵企业面积情况分析 ;
     zfqymjbhqszfqymj = 在孵企业面积变化趋势在孵企业面积 ;
     cyjg = 产业结构 ;
     ykjqypyqk = 硬科技企业培育情况 ;
     rcyj = 人才引进 ;
     fhqhzsj = 孵化器汇总数据 ;
     xzzfqyqk = 新增在孵企业情况 ;
     zyjjnl = 资源集聚能力 ;
     zhnl = 综合能力 ;
     byqyqk = 毕业企业情况 ;
     qycxfsddnl = 区域创新辐射带动能力 ;
     yj = 预警 ;
     qyyj = 企业预警 ;
     qydt = 企业动态 ;
     zfqybhqszfqy = 在孵企业变化趋势在孵企业 ;
     jrfw = 金融服务 ;
     zysje = 总营收金额 ;
     zfqyzys = 在孵企业总营收 ;
     tzlx = 投资类型 ;
     zfqyrzqk = 在孵企业融资情况 ;
     ggjsfw = 公共技术服务 ;
     qyfhl = 企业孵化率 ;
     qyfhs = 企业孵化数 ;
    
    */
    let config = {"zfqymjqkfx":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zfqymjbhqszfqymj":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"cyjg":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"ykjqypyqk":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"rcyj":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"fhqhzsj":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"xzzfqyqk":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zyjjnl":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zhnl":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"byqyqk":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qycxfsddnl":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"yj":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qyyj":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qydt":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zfqybhqszfqy":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"jrfw":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zysje":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"zfqyzys":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"tzlx":{"type":"array","operationsType":"list_changeKey","reflect":"","unitInfo":{}},"zfqyrzqk":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"ggjsfw":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qyfhl":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}},"qyfhs":{"type":"object","operationsType":"object_ToList","reflect":"","unitInfo":{}}};

    let interfaceData = Object.assign({}, jxgljscData );
    let changeData = changeDataProcess('绩效管理驾驶舱', interfaceData, config);
    //todo 剩下的就是将excel定好的数据和interface的数据关联起来了

}
