/**
 * 企业服务
 */

import moment = require("moment");
import { FUHUASTATE, INDUSTRY, MOVEOUTTYPE, OPERATIONALDATATYPE, SELECTPARAM, STATE, TABLENAME, INTELLECTUALPROPERTYRIGHT, IPRTYPECLIENT, EMIGRATIONTYPE, ENTERPRISETEAM, DEGREE } from "../../config/enum";
import { selectData, selectManyTableData } from "./operationalData";
import { getChart, getKeyValue, getMonthList, getYearList } from "./out";
import { Console, count, log } from "console";
import { changeEnumValue } from "../../tools/eccEnum";


export async function getEnterprise() {
    let qyfw = {
        企业基本情况: { dataList: [], titleList: ['key', 'value'] }, //企业基本情况
        变化趋势分析: [], //变化趋势分析
        入孵时长分布: { dataList: [], titleList: ['key', 'value'] }, //入孵时长分布
        孵化企业行业领域占比: { dataList: [], titleList: ['key', 'value'] }, //孵化企业行业领域占比
        企业人才: [], //企业人才
        企业服务汇总数据: { dataList: [], titleList: ['key', 'value'] }, //企业服务汇总数据
        企业需求动态: { dataList: [], titleList: ['key', 'value'] }, //企业需求动态
        // 企业需求动态详细: { bodyList: [], headerList: [['企业名称', '类型', 'eId']] }, //企业需求动态详细
        企业需求动态详细: { bodyList: [], headerList: [['企业名称']] },
        企业变化情况: { dataList: [], titleList: ['key', 'value'] }, //企业变化情况
        企业变化情况变化趋势: [], //企业变化情况——变化趋势
        金融服务: { dataList: [], titleList: ['key', 'value'] }, //金融服务
        本月融资企业: [], //本月融资企业
        本月融资金额: [], //本月融资金额
        在孵企业总营收: { dataList: [], titleList: ['key', 'value'] }, //在孵企业总营收
        金融服务企业: { bodyList: [], headerList: [['企业名称', '融资金额(万元)', '融资时间']] }, //金融服务企业 todo
        知识产权: { dataList: [], titleList: ['key', 'value'] }, //知识产权
        知识产权饼图: { dataList: [], titleList: ['key', 'value'] }, //知识产权饼图
        知识产权详情: { bodyList: [], headerList: [['企业名称', '知识产权数']] }, //知识产权详情 todo
        企业资质分类: { dataList: [], titleList: ['key', 'value'] }, //企业资质分类
        企业资质分类_小巨人: { bodyList: [], headerList: [['企业名称', '资质类型']] }, //企业资质分类_小巨人
        企业资质分类_高新企业: { bodyList: [], headerList: [['企业名称', '资质类型']] }, //企业资质分类_高新企业
        企业资质分类_专精特新: { bodyList: [], headerList: [['企业名称', '资质类型']] }, //企业资质分类_专精特新
        企业资质分类_小巨人培育: { bodyList: [], headerList: [['企业名称', '资质类型']] }, //企业资质分类_小巨人培育
    }

    let nowTime = new Date().valueOf();
    let selectParam = { "endTime": { "%gt%": nowTime } };
    let zlColumn = ["eId", "area", "unitPrice", "isDeposit", "startTime", "endTime", "rentFreeStart", "rentFreeEnd", "roomNumber",
        "rent", "notes", "leaseContract", "entryPlan", "businessLicense", "agreement"];
    /**在孵：获取租赁结束时间大于当前时间的租赁信息 */
    let zldbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.租赁信息, selectParam, zlColumn);

    let qyjbqk = {
        "孵化面积": 0,
        "在孵企业": 0,
        "毕业企业": 0
    };
    zldbList.forEach(item => {
        qyjbqk.孵化面积 += parseInt(item.area);
    })

    let fhColumn = ["fId", "eId", "startTime", "endTime", "state", "virtualCause", "virtualCauseDes", "moveOutType",
        "moveOutTrace", "moveOutCause", "moveOutTime", "graduationTime"];
    //获取所有企业孵化信息
    let fhdbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {}, fhColumn);
    //获取在孵企业
    // let 在孵dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, { "endTime": { "%gt%": nowTime } }, fhColumn);
    let 在孵dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {}, fhColumn);

    //获取毕业企业
    // let 毕业dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, { "moveOutType": MOVEOUTTYPE.毕业迁出 }, fhColumn);
    let 毕业dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, { "moveOutType": EMIGRATIONTYPE.毕业迁出 }, fhColumn);
    //获取所有企业孵化表联查企业信息表
    let 孵化企业includeConf = {};
    let 孵化企业Clumn = ["enterpriseName", "industry"];
    孵化企业includeConf[TABLENAME.企业基础信息表] = { cloum: 孵化企业Clumn, where: {} }
    // let 孵化企业dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业孵化信息, {}, fhColumn, 孵化企业includeConf);

    //企业基本信息
    qyjbqk.在孵企业 = 在孵dbList.length;


    qyjbqk.毕业企业 = 毕业dbList.length;
    qyfw.企业基本情况.dataList = getKeyValue(qyjbqk);

    //变化趋势分析 //todo 需要日志表
    // getBhqsfx(fhdbList);
    let 在孵企业变化趋势 = getZfqy(在孵dbList);
    qyfw.变化趋势分析 = getChart(在孵企业变化趋势);

    //入孵时长分布
    let rfscfb = getRfscfx(fhdbList);
    qyfw.入孵时长分布.dataList = getKeyValue(rfscfb);

    //孵化企业行业领域占比
    // for (let key in INDUSTRY) {
    //     let anyKey: any = key;
    //     if (isNaN(anyKey)) {
    //         let keyStr = key;
    //         let industry = INDUSTRY[key];
    //         let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.企业基础信息表, { industry:{"%like%":industry} }, null);
    //         qyfw.孵化企业行业领域占比.dataList.push({ key: keyStr, value: count })
    //     }
    // }
    //孵化企业行业领域占比---按照企业选择的类型呈现todo
    for (let key in INDUSTRY) {
        let anyKey: any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let industry = INDUSTRY[key];
            let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.企业基础信息表, { industry: { "%like%": industry } }, null);

            // 只有当count大于0时才添加到dataList中
            if (count > 0) {
                qyfw.孵化企业行业领域占比.dataList.push({ key: keyStr, value: count });
            }
        }
    }


    //企业服务汇总数据`
    let qyfwhzsj = await getQyfwhzsj();
    qyfw.企业服务汇总数据.dataList = getKeyValue(qyfwhzsj);

    //企业需求动态
    let 入孵申请dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业基础信息表, { state: STATE.是 }, null);
    let 企业服务Count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.企业服务表, {}, null);
    let { qyxqdt, qyxqdtxx } = await getQyxqdt(入孵申请dbList, 企业服务Count);
    qyfw.企业需求动态.dataList = getKeyValue(qyxqdt);
    //企业需求动态详细 上面3中汇总数据类型的所有企业列表，由于毕业认证企业取不到数据，只汇总入孵申请和企业需求数的企业列表
    qyfw.企业需求动态详细.bodyList = qyxqdtxx;

    //企业变化情况
    let qybhqk = getQybhqk(在孵dbList);
    qyfw.企业变化情况.dataList = getKeyValue(qybhqk);

    //企业变化情况——变化趋势
    let qybhqkbhqs = getQybhqkbhqs(在孵dbList);
    qyfw.企业变化情况变化趋势 = qybhqkbhqs;

    let 企业融资dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业融资, {}, null);

    //金融服务
    let jrfw = await getJrfw(在孵dbList, 企业融资dbList);
    qyfw.金融服务.dataList = getKeyValue(jrfw);

    //本月融资企业
    let byrzqy = await getByrzqy(企业融资dbList);
    qyfw.本月融资企业 = byrzqy.byrzqybhqs;

    //本月融资金额
    qyfw.本月融资金额 = byrzqy.byrzjebhqs;

    //在孵企业总营收
    let zfqyzys = await getZfqyzys(在孵dbList);
    qyfw.在孵企业总营收.dataList = getKeyValue(zfqyzys);

    //金融服务企业
    let rzqylcColumn = ["rId", "eId", "financingAmount", "financingRounds", "fuHuaQiInvestment", "fuHuaQiInvestmentStyle", "fuHuaQiInvestmentAmount",
        "investmentDate", "investmentInstitutionsName", "valuation"];
    let 融资企业联查includeConf = {};
    let 融资企业联查Clumn = ["enterpriseName"];
    融资企业联查includeConf[TABLENAME.企业基础信息表] = { cloum: 融资企业联查Clumn, where: {} }
    let 融资企业联查dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业融资, {}, rzqylcColumn, 融资企业联查includeConf);
    let jrfwqy = getJrfwqy(融资企业联查dbList);
    qyfw.金融服务企业.bodyList = jrfwqy;

    //知识产权
    // let 企业专利dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业专利表, {}, null);
    let 企业专利dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.知识产权, {}, null);
    let { zscqbt } = getZscq(企业专利dbList);
    // qyfw.知识产权.dataList = getKeyValue(zscq);
    qyfw.知识产权饼图.dataList = getKeyValue(zscqbt);

    //知识产权详情 专利数据和服务数据没法保持一致，不知道要怎么样实现在一个表格展现 todo
    let 专利Column = ["eId", "year", "alienPatent", "classIPatent", "secondClassPatent", "thirdPentent"];
    let 知识产权联查includeConf = {};
    // 知识产权联查includeConf[TABLENAME.企业专利表] = {cloum:专利Column, where:{}}
    知识产权联查includeConf[TABLENAME.知识产权] = { cloum: ["number"], where: {} }
    let 知识产权详情dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {}, ["enterpriseName"], 知识产权联查includeConf);
    let zscqxq = await getZscqxq(知识产权详情dbList);
    qyfw.知识产权详情.bodyList = zscqxq;

    //企业资质分类
    let 资质Column = ["qId", "eId", "kxTime", "zjtxTime", "xjrTime", "xjrPyTime", "goPublicTime", "gaoXinJiShuTime", "goPublicSector"];
    let 企业资质联查includeConf = {};
    企业资质联查includeConf[TABLENAME.企业资质] = { cloum: 资质Column, where: {} }
    let 企业资质dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {}, [], 企业资质联查includeConf);
    let { qyzzfl, qyzzflTable } = getQyzzfl(企业资质dbList);
    qyfw.企业资质分类.dataList = getKeyValue(qyzzfl);
    qyfw.企业资质分类_小巨人.bodyList = qyzzflTable.小巨人;
    qyfw.企业资质分类_高新企业.bodyList = qyzzflTable.高新企业;
    qyfw.企业资质分类_专精特新.bodyList = qyzzflTable.专精特新;
    qyfw.企业资质分类_小巨人培育.bodyList = qyzzflTable.小巨人培育;

    let 企业人才就业人数 = await getQyrc();
    qyfw.企业人才 = getChart(企业人才就业人数);

    return qyfw;
}


export async function getEnterpriseDetails(name, type) {
    let nowTime = new Date().valueOf();

    let selectParam = {};
    if (name) selectParam["enterpriseName"] = { "%like%": name };

    let dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId", "enterpriseName"], {});
    // let dbList = [];
    // if (type.length != 0) {
    //     for (let i = 0; i < type.length; i++) {
    //         let manyTableInfo: any = {};
    //         let info = type[i];
    //         switch (info) {
    //             case SELECTPARAM.在孵企业:
    //                 manyTableInfo[TABLENAME.企业孵化信息] = { column: [], where: { "endTime": { "%gt%": nowTime } } };
    //                 break;
    //             case SELECTPARAM.融资企业:
    //                 manyTableInfo[TABLENAME.企业融资] = { column: [], where: { "financingAmount": { "%ne%": null } } };
    //                 break;
    //             case SELECTPARAM.知识产权:
    //                 manyTableInfo[TABLENAME.知识产权] = { column: [], where: {} };
    //                 break;
    //             case SELECTPARAM.专利:
    //                 manyTableInfo[TABLENAME.企业专利表] = { column: [], where: {} };
    //                 break;
    //             case SELECTPARAM.科小:
    //                 manyTableInfo[TABLENAME.企业资质] = { column: [], where: { "kxTime": { "%ne%": null } } };
    //                 break;
    //             case SELECTPARAM.专精特新:
    //                 manyTableInfo[TABLENAME.企业资质] = { column: [], where: { "zjtxTime": { "%ne%": null } } };
    //                 break;
    //             case SELECTPARAM.小巨人:
    //                 manyTableInfo[TABLENAME.企业资质] = { column: [], where: { "xjrTime": { "%ne%": null } } };
    //                 break;
    //             case SELECTPARAM.小巨人培育:
    //                 manyTableInfo[TABLENAME.企业资质] = { column: [], where: { "xjrPyTime": { "%ne%": null } } };
    //                 break;
    //             case SELECTPARAM.高新技术:
    //                 manyTableInfo[TABLENAME.企业资质] = { column: [], where: { "gaoXinJiShuTime": { "%ne%": null } } };
    //                 break;
    //         }

    //         let enterpriseData = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId", "enterpriseName"], manyTableInfo);
    //         enterpriseData.forEach(item => {
    //             dbList.push(item);
    //         });
    //     }
    // } else {
    //     dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, selectParam, ["eId", "enterpriseName"], {});
    // }

    let dataChange = [];
    dbList.forEach(item => {
        let { eId, enterpriseName } = item;
        dataChange.push({ eId, enterpriseName });
    })

    //toupdate 要改掉 少用语法糖
    /**
     * @author: xiaoyouyou
     */
    // let dataList = [...new Map(dataChange.map(item => [item.eId, item])).values()];
    let dataList = [];
    let map = new Map();
    for (let i = 0; i < dataChange.length; i++) {
        let item = dataChange[i];
        if (!map.has(item.eId)) {
            map.set(item.eId, true);
            dataList.push(item);
        }
    }

    return dataList;
}



/**
 * 变化趋势分析
 * @param data 
 */
function getBhqsfx(data) {
    let bhqsfx = {
        "在孵": [],
        "毕业": []
    }

    //todo 变化趋势分析 需要日志表
    bhqsfx["在孵"] = [
        { key: "2019", value: 4 },
        { key: "2020", value: 4 },
    ];
    bhqsfx["毕业"] = [
        { key: "2019", value: 4 },
        { key: "2020", value: 4 },
    ];
    data.forEach(item => {
    })
}


/**
 * 在孵企业——变化趋势
 */
//  function getZfqy(data) {
//     let year = getYearList();
//     let bhqsfx = {
//         "在孵": [],
//         "毕业": []
//     }
//     for (let i = 0; i < year.length; i++) {
//         let count = 0;
//         data.forEach(info => {
//             let startTimeYear = moment(info.startTime).year(); //获取入孵开始时间
//             let thisYear = parseInt(year[i]);
//             if (startTimeYear === thisYear) count += 1;
//         })
//         bhqsfx.在孵.push({ key: year[i], value: count });
//         bhqsfx.毕业.push({ key: year[i], value: count});
//         // bhqsfx.毕业.push({ key: year[i], value: 0 });
//     }

//     // let qybhqkbhqs = getChart(bhqsfx.在孵);

//     return bhqsfx;
// }
function getZfqy(data) {
    let year = getYearList();
    let bhqsfx = {
        "在孵": [],
        "毕业": []
    };

    // 初始化每年的在孵和毕业企业数量为0
    for (let i = 0; i < year.length; i++) {
        bhqsfx.在孵.push({ key: year[i], value: 0 });
        bhqsfx.毕业.push({ key: year[i], value: 0 });
    }

    data.forEach(info => {
        let startTimeYear = moment(info.startTime).year(); // 获取入孵开始时间
        let endTimeYear = moment(info.endTime).year(); // 获取入孵结束时间
        let moveOutType = info.moveOutType;

        // 统计在孵企业
        for (let i = 0; i < year.length; i++) {
            if (parseInt(year[i]) === startTimeYear) {
                bhqsfx.在孵[i].value += 1;
                break;
            }
        }

        // 统计毕业企业
        if (moveOutType === EMIGRATIONTYPE.毕业迁出) {
            for (let i = 0; i < year.length; i++) {
                if (parseInt(year[i]) === endTimeYear) {
                    bhqsfx.毕业[i].value += 1;
                    break;
                }
            }
        }
    });

    return bhqsfx;
}


/**
 * 入孵时长分布--到期时间为孵化截至todo
 * @param data 
 */
function getRfscfx(data) {
    let rfscfx = {
        "即将到期": 0, //3个月
        "1年以内": 0,
        "1-2年": 0,
        "2-3年": 0,
        "3-4年": 0
    };

    let nowTime = moment();
    data.forEach(item => {
        let parsedEndTime = moment(item.endTime); //获取入孵结束时间
        let monthDiff = parsedEndTime.diff(nowTime, 'months');
        if (monthDiff >= 0 && monthDiff < 3) rfscfx.即将到期 += 1;
        else if (monthDiff >= 3 && monthDiff < 12) rfscfx["1年以内"] += 1;
        else if (monthDiff >= 12 && monthDiff < 24) rfscfx["1-2年"] += 1;
        else if (monthDiff >= 24 && monthDiff < 36) rfscfx["2-3年"] += 1;
        else if (monthDiff >= 36 && monthDiff < 48) rfscfx["3-4年"] += 1;
    })

    return rfscfx;
}


/**
 * 企业服务汇总数据
 * @param data 
 */
async function getQyfwhzsj() {
    let qyfwhzsj = {
        "企业总营收额": 0,
        "企业纳税": 0,
        "融资企业": 0,
        "企业专利": 0
    };
    let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, {}, null);
    经营信息dbList.forEach(info => {
        qyfwhzsj.企业总营收额 += parseFloat(info.BI);
        qyfwhzsj.企业纳税 += parseFloat(info.TXP);
    })

    let 企业融资dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业融资, {}, null);
    企业融资dbList.forEach(info => {
        qyfwhzsj.融资企业 += parseInt(info.financingAmount);
    })

    let 企业专利dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.知识产权, {}, null);
    企业专利dbList.forEach(info => {
        qyfwhzsj.企业专利 += parseInt(info.number || 0);
    })

    return qyfwhzsj;
}


/**
 * 企业需求动态----只需轮播企业名称todo
 */
async function getQyxqdt(入孵申请dbList, 企业服务Count) {
    let qyxqdt = {
        入孵申请: 0,
        毕业认证企业: 0,
        企业需求数: 0
    }
    qyxqdt.入孵申请 = 入孵申请dbList.length;
    qyxqdt.企业需求数 = 企业服务Count;

    let qyxqdtxx = [];
    入孵申请dbList.forEach(info => {
        // qyxqdtxx.push([info.enterpriseName, "入孵申请", info.eId]);
        qyxqdtxx.push([info.enterpriseName]);
    })
    //获取所有企业服务表联查企业信息表
    let qyfwColumn = ["esId", "eId", "needCategory", "needContent"];
    let 企业服务includeConf = {};
    企业服务includeConf[TABLENAME.企业基础信息表] = { cloum: ["enterpriseName"], where: {} }
    let 企业服务dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业服务表, {}, qyfwColumn, 企业服务includeConf);
    企业服务dbList.forEach(info => {
        // qyxqdtxx.push([info.enterprise.enterpriseName, "企业需求", info.enterprise.eId]);
        qyxqdtxx.push([info.enterprise.enterpriseName]);
    })

    return { qyxqdt, qyxqdtxx };
}


/**
 * 企业变化情况
 * @param data 
 */
// function getQybhqk(data) {
//     let qybhqk = {
//         新增企业: 0, //统计当前年份入孵企业
//         迁出企业: 0
//     }

//     let nowTime = moment();
//     data.forEach(info => {
//         let parsedStartTime = moment(info.startTime); //获取入孵开始时间
//         // 检查日期字段的年份是否与当前年份相同
//         if (parsedStartTime.isValid() && parsedStartTime.year() === nowTime.year()) {
//             qybhqk.新增企业 += 1;
//         }
//     })

//     return qybhqk;
// }
function getQybhqk(data) {
    let qybhqk = {
        新增企业: 0, // 统计当前年份入孵企业
        迁出企业: 0 // 统计当前年份迁出企业
    }

    let nowTime = moment();
    data.forEach(info => {
        let parsedStartTime = moment(info.startTime); // 获取入孵开始时间
        let parsedMoveOutTime = moment(info.moveOutTime); // 获取迁出时间

        // 检查入孵开始时间的年份是否与当前年份相同
        if (parsedStartTime.isValid() && parsedStartTime.year() === nowTime.year()) {
            qybhqk.新增企业 += 1;
        }

        // 检查迁出时间的年份是否与当前年份相同
        if (parsedMoveOutTime.isValid() && parsedMoveOutTime.year() === nowTime.year()) {
            qybhqk.迁出企业 += 1;
        }
    })

    return qybhqk;
}


/**
 * 企业变化情况——变化趋势
 */
function getQybhqkbhqs(data) {
    let year = getYearList();
    let hbqs = {
        "企业数": []
    }
    for (let i = 0; i < year.length; i++) {
        let count = 0;
        data.forEach(info => {
            let startTimeYear = moment(info.startTime).year(); //获取入孵开始时间
            let thisYear = parseInt(year[i]);
            if (startTimeYear === thisYear) count += 1;
        })
        hbqs.企业数.push({ key: year[i], value: count });
    }

    let qybhqkbhqs = getChart(hbqs);

    return qybhqkbhqs;
}


/**
 * 金融服务
 */
async function getJrfw(data, 企业融资dbList) {
    let jrfw = {
        本月融资企业: 0,
        本月融资金额: 0,
        在孵企业总营收: 0
    }

    let nowTime = moment();
    企业融资dbList.forEach(info => {
        let parsedTime = moment(info.investmentDate).format("YY/MM"); //获取融资时间
        if (parsedTime === moment(nowTime).format("YY/MM")) {
            jrfw.本月融资企业 += 1;
            jrfw.本月融资金额 += parseFloat(info.financingAmount);
        }
    })

    // jrfw.本月融资金额 = Math.round((jrfw.本月融资金额 / 100000000) * 100) / 100; //单位换算成万亿
    jrfw.本月融资金额 = Math.round((jrfw.本月融资金额) * 100) / 100; //单位换算成万亿
    for (let i = 0; i < data.length; i++) {
        //获取在孵企业经营数据
        let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, { eId: data[i].eId }, null);
        经营信息dbList.forEach(info => {
            jrfw.在孵企业总营收 += parseFloat(info.BI);
        })
    }

    return jrfw;
}


/**
 * 本月融资企业
 * @param data
 * @returns 
 */
async function getByrzqy(企业融资dbList) {
    /**获取距离当前时间的前6个月 */
    let month = getMonthList();

    let byrzqy = {
        "融资企业": []
    }
    let byrzje = {
        "融资金额": []
    }
    for (let i = 0; i < month.length; i++) {
        let 企业count = 0;
        let 金额count = 0;
        企业融资dbList.forEach(info => {
            let parsedTime = moment(info.investmentDate).format("YY/MM"); //获取融资时间
            if (parsedTime === month[i]) {
                企业count += 1;
                金额count += parseFloat(info.financingAmount);
            }
        })
        // 金额count = 金额count / 100000000; //单位换算成万亿
        byrzqy["融资企业"].push({ key: month[i], value: 企业count });
        byrzje["融资金额"].push({ key: month[i], value: 金额count });
    }

    let byrzqybhqs = getChart(byrzqy);
    let byrzjebhqs = getChart(byrzje);

    return { byrzqybhqs, byrzjebhqs };
}


/**
 * 在孵企业总营收
 */
async function getZfqyzys(data) {
    let zfqyzys = {
        "500万以下": 0,
        "500万-1000万": 0,
        "1000万-2000万": 0,
        "2000万以上": 0
    }

    for (let i = 0; i < data.length; i++) {
        //获取在孵企业经营数据
        let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, { eId: data[i].eId }, null);
        经营信息dbList.forEach(info => { //BI（单位万元）
            if (info.BI < 500) zfqyzys["500万以下"] += 1;
            else if (info.BI >= 500 && info.BI < 1000) zfqyzys["500万-1000万"] += 1;
            else if (info.BI >= 1000 && info.BI < 2000) zfqyzys["1000万-2000万"] += 1;
            else zfqyzys["2000万以上"] += 1;
        })
    }

    return zfqyzys
}


/**
 * 金融服务企业
 * @param data 
 */
function getJrfwqy(data) {
    let jrfwqy = [];
    data.forEach(info => {
        let { financingAmount, enterprise, investmentDate } = info;
        let thisTime = moment(investmentDate).format("YYYY-MM-DD");
        jrfwqy.push([enterprise.enterpriseName, financingAmount, thisTime]);
    })

    return jrfwqy;
}


/**
 * 知识产权-------设计图有改动todo
 */
function getZscq(data) {
    let zscqbt = {
        // 软件著作: 0,
        软件著作权: 0,
        发明专利: 0,
        海外专利: 0,
        其他: 0
        // 植物新品种: 0,
        // 集成电路布图: 0
    }

    data.forEach(info => {
        switch (info.iprType) {
            case IPRTYPECLIENT.软件著作权:
                zscqbt.软件著作权 += info.number;
                break;
            case IPRTYPECLIENT.发明专利:
                zscqbt.发明专利 += info.number;
                break;
            case IPRTYPECLIENT.海外专利:
                zscqbt.海外专利 += info.number;
                break;
            case IPRTYPECLIENT.植物新品种:
            case IPRTYPECLIENT.集成电路布图:
                zscqbt.其他 += info.number;
                break;
        }
    })

    return { zscqbt };
}


/**
 * 知识产权详情
 */
// function getZscqxq(data) {
//     let dataList = [];
//     data.forEach( info => {
//         let {enterprise_patents, enterprise_iprs, enterpriseName} = info;
//         let patentsCount = 0;
//         let iprsCount = 0;
//         enterprise_patents.forEach(item => {
//             if(item.alienPatent) patentsCount += item.alienPatent;
//             if(item.classIPatent) patentsCount += item.classIPatent;
//             if(item.secondClassPatent) patentsCount += item.secondClassPatent;
//             if(item.thirdPentent) patentsCount += item.thirdPentent;
//         });
//         enterprise_iprs.forEach(item => {
//             if(item.number) iprsCount += item.number;
//         });
//         dataList.push([enterpriseName, patentsCount, iprsCount]);
//     });

//     return dataList;
// }
function getZscqxq(data) {
    let dataList = [];
    data.forEach(info => {
        let { enterprise_iprs, enterpriseName } = info;
        let iprsCount = enterprise_iprs.length;
        dataList.push([enterpriseName, iprsCount]);
    });

    return dataList;
}


/**
 * 企业资质分类
 */
function getQyzzfl(data) {
    let qyzzfl = {
        小巨人: 0,
        高新企业: 0,
        专精特新: 0,
        小巨人培育: 0,
    }

    let qyzzflTable = {
        小巨人: [],
        高新企业: [],
        专精特新: [],
        小巨人培育: [],
    };

    data.forEach(info => {
        let { enterprise_qualifications } = info;
        enterprise_qualifications.forEach(item => {
            if (item.xjrTime) {
                qyzzfl.小巨人 += 1;
                qyzzflTable.小巨人.push([info.enterpriseName, "小巨人"]);
            }
            else if (item.gaoXinJiShuTime) {
                qyzzfl.高新企业 += 1;
                qyzzflTable.高新企业.push([info.enterpriseName, "高新企业"]);
            }
            else if (item.zjtxTime) {
                qyzzfl.专精特新 += 1;
                qyzzflTable.专精特新.push([info.enterpriseName, "专精特新"]);
            }
            else if (item.xjrPyTime) {
                qyzzfl.小巨人培育 += 1;
                qyzzflTable.小巨人培育.push([info.enterpriseName, "小巨人培育"]);
            }
        })
    })

    return { qyzzfl, qyzzflTable }
}



/**
 * 企业人才--创业团队分布todo
 */
async function getQyrc() {
    // let year = getYearList();
    let qyrc = {
        "就业人数": [],
        // "创业团队分布": []
    }

    //就业
    let jiuYeList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.参保记录, {}, null);
    let 年度就业人数趋势分析Map = {};
    jiuYeList.forEach(info => {
        let { eId, annual } = info;
        let itemCount = 0;
        let itemYear = new Date(annual).getFullYear();
        if (info.zhuanKe) itemCount += parseInt(info.zhuanKe);
        if (info.benKe) itemCount += parseInt(info.benKe);
        if (info.shuoshi) itemCount += parseInt(info.shuoshi);
        if (info.boShi) itemCount += parseInt(info.boShi);
        if (info.boshiyishang) itemCount += parseInt(info.boshiyishang);

        if (!年度就业人数趋势分析Map[itemYear]) 年度就业人数趋势分析Map[itemYear] = { key: itemYear, value: 0 };
        年度就业人数趋势分析Map[itemYear].value += itemCount;
    });
    let 年度就业人数趋势分析 = Object.values(年度就业人数趋势分析Map);
    qyrc["就业人数"] = 年度就业人数趋势分析;

    //创业团队分布
    // let qyrcList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.创业团队, {}, null);
    // qyrcList.forEach(info => {
    //     let { eId, name, sex, birth, degree, graduationSchool, talentType, des } = info;
    //     qyrc["创业团队分布"].push({
    //         eId,
    //         name,
    //         sex,
    //         birth,
    //         degree,
    //         graduationSchool,
    //         talentType,
    //         des,
    //     });
    // });
    // // 统计每年的创业团队数量 学历

    // let 年度创业团队趋势分析Map = {};
    // qyrcList.forEach(info => {
    //     let birthYear = new Date(info.birth).getFullYear();
    //     if (!年度创业团队趋势分析Map[birthYear]) 年度创业团队趋势分析Map[birthYear] = { key: birthYear, value: 0 };
    //     年度创业团队趋势分析Map[birthYear].value += 1;
    // });
    // // let 年度创业团队趋势分析 = Object.values(年度创业团队趋势分析Map);
    // let 年度创业团队趋势分析 = Object.values(年度创业团队趋势分析Map) as { key: number; value: number }[];
    // 年度创业团队趋势分析.sort((a, b) => a.key - b.key);
    // qyrc["创业团队分布"] = 年度创业团队趋势分析;
    
    return qyrc;
}




