"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.postForm = exports.post = exports.get = void 0;
const request = require("request");
const bizError_1 = require("./bizError");
function get(url, query, headers, timeOut) {
    timeOut = timeOut || 5000;
    if (!url || (url.search(/http:/) && url.search(/https:/)))
        throw new bizError_1.BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject) => {
        let paramater = { url, json: true, timeout: timeOut };
        if (query)
            paramater.qs = query;
        if (headers)
            paramater.headers = headers;
        request.get(paramater, function (err, res, body) {
            const success = !err && res && res == 200;
            let message = err || res.statusCode || "";
            resolve({ success, message, body });
        });
    });
}
exports.get = get;
function post(url, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)))
        throw new bizError_1.BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = { "content-type": "application/json" };
    return new Promise((resolve, reject) => {
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body: body
        }, function (err, res, body) {
            const success = !err && res && res == 200;
            let message = err || res.statusCode || "";
            resolve({ success, code: message, data: body.data });
        });
    });
}
exports.post = post;
function postForm(url, body) {
    if (!url || (url.search(/http:/) && url.search(/https:/)))
        throw new bizError_1.BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject) => {
        request({
            url: url,
            method: "POST",
            json: true,
            form: body
        }, function (err, res, body) {
            const success = !err && res && res == 200;
            let message = err || res.statusCode || "";
            resolve({ success, message, body });
        });
    });
}
exports.postForm = postForm;
//# sourceMappingURL=request.js.map