"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFileType = exports.getDefPwd = exports.getPartyMemberId = exports.getClientMs = exports.getMySqlMs = exports.getUserToken = exports.successErrorResult = exports.successResult = exports.generatePwd = exports.generateUserId = exports.generateToken = exports.generateSystemId = void 0;
const moment = require("moment");
const errorEnum_1 = require("../config/errorEnum");
const bizError_1 = require("../util/bizError");
const enum_1 = require("../config/enum");
const md5 = require("md5");
/**
 * 生成系统id
 * @param tableName
 * @param userId
 * @returns
 */
function generateSystemId(tableName, userId) {
    return md5(`${tableName}${Math.floor(Math.random() * 10000)}${userId}${new Date().valueOf()}${Math.floor(Math.random() * 100)}`);
}
exports.generateSystemId = generateSystemId;
/**
 * 生成token
 * @param userId
 * @returns
 */
function generateToken(userId) {
    return md5(`${userId}${Math.floor(Math.random() * 10000)}${new Date().valueOf()}${Math.floor(Math.random() * 100)}`);
}
exports.generateToken = generateToken;
/**
 * 生成userid
 */
function generateUserId(phone) {
    let str = `${Math.random() * 100}${new Date().valueOf()}${Math.floor(Math.random() * 10000)}`;
    if (phone)
        str += phone;
    return md5(str);
}
exports.generateUserId = generateUserId;
/**
 * 生成密码
 * @param userId
 * @returns
 */
function generatePwd(userId, pwd) {
    return md5(`${userId}${pwd}`);
}
exports.generatePwd = generatePwd;
/**
 * 返回编辑正确的结果
 * @returns
 */
function successResult() {
    return { success: true };
}
exports.successResult = successResult;
/**
 * 抛出错误信息
 * @returns
 */
function successErrorResult(msg) {
    return { code: 500, success: false, msg };
}
exports.successErrorResult = successErrorResult;
function getUserToken(loginId) {
    return md5(`${loginId}_${Math.ceil(Math.random() * 1000)}${new Date().valueOf()}`);
}
exports.getUserToken = getUserToken;
function getMySqlMs(time) {
    time = time || new Date().valueOf();
    // time += (8*3600*1000);
    return moment(time).format("YYYY-MM-DD HH:mm:ss");
}
exports.getMySqlMs = getMySqlMs;
function getClientMs(time) {
    if (!time)
        return new Date().valueOf();
    return new Date(time).valueOf();
}
exports.getClientMs = getClientMs;
function getPartyMemberId(param) {
    return md5(`${param}-${new Date().valueOf()}-${Math.ceil(Math.random() * 10000)}`);
}
exports.getPartyMemberId = getPartyMemberId;
function getDefPwd(phone) {
    return md5(`${phone.slice(5, 11)}`);
}
exports.getDefPwd = getDefPwd;
function getFileType(fileName) {
    let fileType = 0;
    fileName.forEach(info => {
        let repList = info.split(".");
        let type = repList[repList.length - 1];
        if (!type)
            throw new bizError_1.BizError(errorEnum_1.ERRORENUM.文件不存在, `文件名 ${info}`);
        let typeNum = 0;
        switch (type) {
            case 'pdf':
                typeNum = enum_1.FILETYPE.pdf;
                break;
            case 'doc':
            case 'docx':
                typeNum = enum_1.FILETYPE.word;
                break;
            case 'jpg':
            case 'png':
                typeNum = enum_1.FILETYPE.图片;
                break;
        }
        ;
        if (typeNum) {
            if (!fileType)
                fileType = typeNum;
            else if (fileType != typeNum)
                fileType = enum_1.FILETYPE.多类型;
        }
    });
    return fileType;
}
exports.getFileType = getFileType;
//# sourceMappingURL=systemTools.js.map