"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.designativListKeyAddUnit = exports.getDesignativByReflect = exports.changeListObjectToListByReflect = exports.changeObjectKey = exports.changeObjectToList = void 0;
/**
 * changeObjectToList  将对象形式的数据转换为keyvalue的数组  对象中的键名称将作为key  传入mapping时 使用对应的change作为key的值
 * @param data 数据{key1:value1, key2:value2, key3:value3...}
 * @param reflect 对应关系 [{key:"key1",change:"名称1"},{key:"key2", change:"名称2"},{key:"key3", change:"名称3"}]
 * @returns [{key:"名称1", value:value1}, {key:"名称2", value:value2}, {key:key3, value:value3}]
 */
function changeObjectToList(data, reflect) {
    let keyList = [];
    if (!reflect || !reflect.length) {
        for (let key in data) {
            keyList.push({ key, change: key });
        }
    }
    let dataList = [];
    keyList.forEach(info => {
        let { key, change } = info;
        let value = data[key];
        if (value)
            dataList.push({ key: change, value: `${value}` });
    });
    return dataList;
}
exports.changeObjectToList = changeObjectToList;
/**
 * changeObjectKey  按mapping的对应关系修改 data中的key  如果对应关系中找不到，则会使用原来的key
 * @param data {key1:value1, key2:value2, key3:value3...}
 * @param reflect {"key1":"名称1", "key2":"名称2", "key3":"名称3"}
 * @returns {"名称1":value1, "名称2":value2, "名称3":value3}
 */
function changeObjectKey(data, reflect) {
    let result = {};
    for (let key in data) {
        let changeKey = reflect[key] || key;
        result[changeKey] = `${data[key]}`;
    }
    return result;
}
exports.changeObjectKey = changeObjectKey;
/**
 * changeListObjectToListByReflect  将data中的object的key替换成 reflect对应的值
 * @param data [{key1:value1, key2:value2...}, {key1:value1, key2:value2...}, {key1:value1, key2:value2...}]
 * @param reflect 映射 不传就不会替换 {"key1":"名称1", "key2":"名称2", "key3":"名称3"}
 * @returns  [{"名称1":value1, "名称2":value2...}, {"名称1":value1, "名称2":value2...}, {"名称1":value1, "名称2":value2...}]
 */
function changeListObjectToListByReflect(data, reflect) {
    let dataList = [];
    if (!reflect)
        return dataList;
    data.forEach(item => {
        let changeInfo = {};
        for (let key in item) {
            let newKey = reflect[key] || key;
            changeInfo[newKey] = `${item[key]}`;
        }
        dataList.push(changeInfo);
    });
    return dataList;
}
exports.changeListObjectToListByReflect = changeListObjectToListByReflect;
/**
 * getDesignativByReflect 获取data中指定的的key
 * @param data  [{key1:value1, key2:value2, key3:value3...}, {key1:value1, key2:value2, key3:value3...}, {key1:value1, key2:value2, key3:value3...}] 或者 {key1:value1, key2:value2, key3:value3...}
 * @param reflect List 映射 必须参数 ["key1", "key2"]  为key的名称
 * @returns [{key1:value1, key2:value2, ...}, {key1:value1, key2:value2, ...}, {key1:value1, key2:value2, ...}]
 */
function getDesignativByReflect(data, reflect) {
    if (typeof data != "object")
        return data;
    let type = Array.isArray(data) ? "array" : "object";
    if ((type == "array" && !reflect.length) || (type == "object" && !Object.keys(reflect)))
        return data;
    let reflectMap = {};
    reflect.forEach(keyName => { reflectMap[keyName] = 1; });
    if (type == "array") {
        let dataList = [];
        data.forEach(item => {
            let once = {};
            for (let key in item) {
                if (!reflectMap[key])
                    continue;
                once[key] = item[key];
            }
            dataList.push(once);
        });
        return dataList;
    }
    else {
        let dataInfo = {};
        for (let key in reflectMap) {
            if (data[key])
                dataInfo[key] = data[key];
        }
        return dataInfo;
    }
}
exports.getDesignativByReflect = getDesignativByReflect;
/**
 * designativListKeyAddUnit为集合中指定的key添加单位
 * @param data [{key1:value1, key2:value2, key3:value3...}, {key1:value1, key2:value2, key3:value3...}, {key1:value1, key2:value2, key3:value3...}]
 * @param reflect {key1:"%", key2:"个"}
 * @returns [{key1:"value1%", ke2:"value2个", keys:"value3"}]
 */
function designativListKeyAddUnit(data, reflect) {
    let dataList = [];
    data.forEach(item => {
        let onceData = {};
        for (let key in item) {
            let unit = reflect[key] || '';
            onceData[key] = `${item[key]}${unit}`;
        }
        dataList.push(onceData);
    });
    return dataList;
}
exports.designativListKeyAddUnit = designativListKeyAddUnit;
//# sourceMappingURL=interfaceAnalysis.js.map