"use strict";
//打包完数据之后的处理
Object.defineProperty(exports, "__esModule", { value: true });
exports.recombinationObject = void 0;
/**
 * recombinationObject 重组对象 在打包完数据后使用 必须是keyvalue之后
 * @param data [{key:key1, value:value1, unit:unit1 }, {key:key2, value:value2, unit:unit2}]
 * @param check {"key2":[{key:"key1", name:""}] }
 * @returns [{key:key1, value:value1, key2:key2, value2:value2}]
 */
function recombinationObject(data, checkInfo) {
    let dataMap = {};
    data.forEach(info => {
        let { key } = info;
        dataMap[key] = info;
    });
    let removeKeyMap = {};
    for (let checkKey in checkInfo) {
        let checkList = checkInfo[checkKey];
        checkList.forEach(item => {
            let { key, name } = item;
            removeKeyMap[key] = 1;
            let onceCheck = dataMap[key];
            dataMap[checkKey][name] = onceCheck.value;
            dataMap[checkKey][`${name}Unit`] = onceCheck.unit;
        });
    }
    let dataList = [];
    data.forEach(info => {
        let { key } = info;
        if (removeKeyMap[key])
            return;
        dataList.push(dataMap[key]);
    });
    return dataList;
}
exports.recombinationObject = recombinationObject;
//# sourceMappingURL=inBackOut.js.map