"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zhyyTableData = void 0;
const planaryArrayAnalysis_1 = require("../../dataPackage/planaryArrayAnalysis");
const analysisExcel_1 = require("../../util/analysisExcel");
function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};
    for (let i = 0; i < blockDataList.length; i++) {
        let { blockData, blockTitle } = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDecollateForIndex(blockData);
    }
    return result;
}
function zhyyTableData() {
    let blockDataList = analysisExcel_1.onceSheetBecomeOfblockData('yuyiServer.xlsx', '智慧运营');
    let keyValueOrTitleList = ["园区概况", "在孵企业数据", "入驻企业行业类型", "孵化运营", "荣誉资质", "智慧运营汇总数据", "就业分析", "产业规模分析", "在孵企业营收占比", "企业服务", "企业服务类型", "产业政策", "产业政策详细", "园区活动", "园区新闻"]; //适配 饼图 键值以及需要多个key的
    let barChartList = ["入驻企业变化趋势", "孵化面积变化趋势", "在孵企业变化趋势", "毕业企业变化趋势", "融资企业变化趋势", "季度就业人数趋势分析", "运营收入趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = ["地图", "服务质量"]; //适配 表格
    let titltListConfig = {};
    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}
exports.zhyyTableData = zhyyTableData;
//# sourceMappingURL=zhyyData.js.map