"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.qyszhxTableData = void 0;
const planaryArrayAnalysis_1 = require("../../dataPackage/planaryArrayAnalysis");
const analysisExcel_1 = require("../../util/analysisExcel");
function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};
    for (let i = 0; i < blockDataList.length; i++) {
        let { blockData, blockTitle } = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDecollateForIndex(blockData);
    }
    return result;
}
function qyszhxTableData() {
    let blockDataList = analysisExcel_1.onceSheetBecomeOfblockData('yuyiServer.xlsx', '企业数字画像');
    let keyValueOrTitleList = ["企业基本情况", "企业基本数据", "企业标签", "知识产权", "企业员工画像", "企业汇总数据", "营收情况", "服务需求", "服务记录", "园区通知", "园区活动"]; //适配 饼图 键值以及需要多个key的
    let barChartList = ["历年人才招聘情况", "营收变化趋势", "活动变化趋势分析"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = ["小巨人", "高新企业", "专精特新", "企业动态", "服务记录_空间服务", "服务记录_工商服务", "服务记录_融资服务", "园区通知详情", "园区活动明细"]; //适配 表格
    let titltListConfig = {};
    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}
exports.qyszhxTableData = qyszhxTableData;
//# sourceMappingURL=qyszhxData.js.map