"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.jxgljscTableData = void 0;
const planaryArrayAnalysis_1 = require("../../dataPackage/planaryArrayAnalysis");
const analysisExcel_1 = require("../../util/analysisExcel");
function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};
    for (let i = 0; i < blockDataList.length; i++) {
        let { blockData, blockTitle } = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1)
            result[blockTitle] = planaryArrayAnalysis_1.planarArrDecollateForIndex(blockData);
    }
    return result;
}
function jxgljscTableData() {
    let blockDataList = analysisExcel_1.onceSheetBecomeOfblockData('yuyiServer.xlsx', '绩效管理驾驶舱');
    let keyValueOrTitleList = ["在孵企业面积情况分析", "产业结构", "人才引进", "孵化器汇总数据", "新增在孵企业情况", "资源集聚能力", "综合能力", "毕业企业情况", "区域创新辐射带动能力", "预警", "企业预警", "企业动态", "金融服务", "总营收金额", "在孵企业总营收", "投资类型", "在孵企业融资情况", "公共技术服务", "企业孵化率", "企业孵化数"]; //适配 饼图 键值以及需要多个key的
    let barChartList = ["在孵企业面积变化趋势", "在孵企业变化趋势"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList = ["硬科技企业培育情况"]; //适配 表格
    let titltListConfig = {};
    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}
exports.jxgljscTableData = jxgljscTableData;
//# sourceMappingURL=jxgljscData.js.map