"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getData = void 0;
const serverConfig_1 = require("../config/serverConfig");
const qyfwData_1 = require("../data/table/qyfwData");
const inFrontOut_1 = require("../dataPackage/inFrontOut");
const out_1 = require("../dataPackage/out");
/*                            企业服务                    */
async function getData(req, res) {
    // let dbData = await getEnterprise();
    let excelData = qyfwData_1.qyfwTableData();
    let ret = {};
    let qyjbqkPackageData = inFrontOut_1.keyValuePackage(excelData['企业基本情况'].dataList);
    ret['qyjbqk'] = out_1.getKeyValueOut('企业基本情况', qyjbqkPackageData);
    let bhqsfxPackageData = inFrontOut_1.onceYBarChartPackage(excelData['变化趋势分析'], '', '');
    ret['bhqsfx'] = out_1.getOnceYBarChartOut('变化趋势分析', bhqsfxPackageData);
    let rfszfbPackageData = inFrontOut_1.keyValuePackage(excelData['入孵时长分布'].dataList);
    ret['rfszfb'] = out_1.getKeyValueOut('入孵时长分布', rfszfbPackageData);
    let fhqyhylyzbPackageData = inFrontOut_1.keyValuePackage(excelData['孵化企业行业领域占比'].dataList);
    ret['fhqyhylyzb'] = out_1.getKeyValueOut('孵化企业行业领域占比', fhqyhylyzbPackageData);
    let qyrcPackageData = inFrontOut_1.onceYBarChartPackage(excelData['企业人才'], '', '');
    ret['qyrc'] = out_1.getOnceYBarChartOut('企业人才', qyrcPackageData);
    let qyfwhzsjPackageData = inFrontOut_1.keyValuePackage(excelData['企业服务汇总数据'].dataList);
    ret['qyfwhzsj'] = out_1.getKeyValueOut('企业服务汇总数据', qyfwhzsjPackageData);
    let qyxqdtPackageData = inFrontOut_1.keyValuePackage(excelData['企业需求动态'].dataList);
    ret['qyxqdt'] = out_1.getKeyValueOut('企业需求动态', qyxqdtPackageData);
    let qyxqdtxxTableData = inFrontOut_1.tablePackage(excelData["企业需求动态详细"].headerList[0], excelData["企业需求动态详细"].bodyList);
    let itemDataList = [];
    qyxqdtxxTableData.dataList.forEach(info => {
        info.eId = "xxxx";
        itemDataList.push(info);
    });
    qyxqdtxxTableData.dataList = itemDataList;
    ret['qyxqdtxx'] = out_1.getTableOut('企业需求动态详细', qyxqdtxxTableData);
    let dtTableData = inFrontOut_1.tablePackage(excelData["地图"].headerList[0], excelData["地图"].bodyList);
    let dt = { dataList: [], titleList: dtTableData.titleList };
    dtTableData.dataList.forEach(info => {
        let { D } = info;
        let imgUrl = `${serverConfig_1.systemConfig.imgPath}/${D}`;
        info["D"] = imgUrl;
        dt.dataList.push(info);
    });
    ret['dt'] = out_1.getTableOut('地图', dt);
    let qybhqkPackageData = inFrontOut_1.keyValuePackage(excelData['企业变化情况'].dataList);
    ret['qybhqk'] = out_1.getKeyValueOut('企业变化情况', qybhqkPackageData);
    let bhqsPackageData = inFrontOut_1.onceYBarChartPackage(excelData['变化趋势'], '家', '');
    ret['bhqs'] = out_1.getOnceYBarChartOut('变化趋势', bhqsPackageData);
    let jrfwPackageData = inFrontOut_1.keyValuePackage(excelData['金融服务'].dataList);
    ret['jrfw'] = out_1.getKeyValueOut('金融服务', jrfwPackageData);
    let byrzqyPackageData = inFrontOut_1.onceYBarChartPackage(excelData['本月融资企业'], '', '');
    ret['byrzqy'] = out_1.getOnceYBarChartOut('本月融资企业', byrzqyPackageData);
    let byrzjePackageData = inFrontOut_1.onceYBarChartPackage(excelData['本月融资金额'], '', '');
    ret['byrzje'] = out_1.getOnceYBarChartOut('本月融资金额', byrzjePackageData);
    let zfqyzysPackageData = inFrontOut_1.keyValuePackage(excelData['在孵企业总营收'].dataList);
    ret['zfqyzys'] = out_1.getKeyValueOut('在孵企业总营收', zfqyzysPackageData);
    let jrfwqyTableData = inFrontOut_1.tablePackage(excelData["金融服务企业"].headerList[0], excelData["金融服务企业"].bodyList);
    ret['jrfwqy'] = out_1.getTableOut('金融服务企业', jrfwqyTableData);
    let zscqPackageData = inFrontOut_1.keyValuePackage(excelData['知识产权'].dataList);
    ret['zscq'] = out_1.getKeyValueOut('知识产权', zscqPackageData);
    let zscqbtPackageData = inFrontOut_1.keyValuePackage(excelData['知识产权饼图'].dataList);
    ret['zscqbt'] = out_1.getKeyValueOut('知识产权饼图', zscqbtPackageData);
    let zscqxqTableData = inFrontOut_1.tablePackage(excelData["知识产权详情"].headerList[0], excelData["知识产权详情"].bodyList);
    ret['zscqxq'] = out_1.getTableOut('知识产权详情', zscqxqTableData);
    let qyzzflPackageData = inFrontOut_1.keyValuePackage(excelData['企业资质分类'].dataList);
    ret['qyzzfl'] = out_1.getKeyValueOut('企业资质分类', qyzzflPackageData);
    let qyzzfl_xjrTableData = inFrontOut_1.tablePackage(excelData["企业资质分类_小巨人"].headerList[0], excelData["企业资质分类_小巨人"].bodyList);
    ret['qyzzfl_xjr'] = out_1.getTableOut('企业资质分类_小巨人', qyzzfl_xjrTableData);
    let qyzzfl_gxqyTableData = inFrontOut_1.tablePackage(excelData["企业资质分类_高新企业"].headerList[0], excelData["企业资质分类_高新企业"].bodyList);
    ret['qyzzfl_gxqy'] = out_1.getTableOut('企业资质分类_高新企业', qyzzfl_gxqyTableData);
    let qyzzfl_zjtxTableData = inFrontOut_1.tablePackage(excelData["企业资质分类_专精特新"].headerList[0], excelData["企业资质分类_专精特新"].bodyList);
    ret['qyzzfl_zjtx'] = out_1.getTableOut('企业资质分类_专精特新', qyzzfl_zjtxTableData);
    let qyzzfl_gqpyTableData = inFrontOut_1.tablePackage(excelData["企业资质分类_高企培育"].headerList[0], excelData["企业资质分类_高企培育"].bodyList);
    ret['qyzzfl_gqpy'] = out_1.getTableOut('企业资质分类_高企培育', qyzzfl_gqpyTableData);
    res.send(ret);
}
exports.getData = getData;
//# sourceMappingURL=qyfw.js.map