"use strict";
/**创业团队 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTeamTalentInfo = exports.addTeamTalent = void 0;
const eccParamConfig_1 = require("../../config/eccParamConfig");
const enum_1 = require("../../config/enum");
const operationalData_1 = require("../../data/db/operationalData");
const eccEnum_1 = require("../../tools/eccEnum");
const eccParam_1 = require("../../tools/eccParam");
const systemTools_1 = require("../../tools/systemTools");
/**
 * 添加人才信息
 * @param userInfo
 * @param param
 * @returns
 */
async function addTeamTalent(userInfo, param) {
    const FuncName = "添加创业团队人才信息";
    eccParam_1.eccFormParam(FuncName, eccParamConfig_1.CreateTeamConfig, param);
    eccEnum_1.eccEnumValue(FuncName, "degree", enum_1.DEGREE, param.degree);
    eccEnum_1.eccEnumValue(FuncName, "talentType", enum_1.RALENTTYPE, param.talentType);
    param.tId = systemTools_1.generateSystemId(enum_1.TABLENAME.创业团队, userInfo.userId);
    param.uploadTime = systemTools_1.getMySqlMs();
    param.dataMonth = systemTools_1.getMySqlMs(param.dataMonth);
    param.fileType = systemTools_1.getFileType(param.fileName);
    param.fileName = JSON.stringify(param.fileName);
    await operationalData_1.operationalData(enum_1.OPERATIONALDATATYPE.增加, enum_1.TABLENAME.创业团队, param, {});
    return { isSuccess: true };
}
exports.addTeamTalent = addTeamTalent;
async function updateTeamTalentInfo() {
}
exports.updateTeamTalentInfo = updateTeamTalentInfo;
//# sourceMappingURL=team.js.map