import { separateDataAndUint, unifiedMaxAndMinValueAndStep } from "./tool";
//数据出口封装 只做封装 少量的数据校验

/**
 * getStringOut  获取文字列表返回结果
 * @param title  数据标题
 * @param data 数据体 格式:["txt...", "str..."]
 * @returns {title, dataList:[string...]}
 */
export function getStringOut(title, data) {
    let dataList = [];
    data.forEach( (str) => {
        dataList.push(str);
    });
    return { title, dataList};
}

/**
 * getOnceYBarChartOut  获取单y轴柱状图
 * @param title 数据标题 
 * @param data  数据体  格式： {xUnit:x轴单位, yUnit:y单位, dataInfo:{"图表名称":[{key:"数据key", value:"数据值", unit:"单位" }, {key:"数据key", value:"数据值", unit:"单位" } ]    }   }
 * @returns {title:标题, xUnit:x轴单位, yUnit:y轴单位, yMinValue:最小值, yMaxValue:最大值, yStepValue:间隔, 
 * chartList:[{thisChartTitle:数据名称, total:总数, unit:单位, dataList:[{name:y轴名称, value:值, unit:单位}] } ]}
 * 入参data里面的dataInfo中的unit可以为空 会读取yUnit 所以入参优先度 yUnit > unit  默认值都是空字符串
 */
export function getOnceYBarChartOut(title, data, stepCount?) {
    let chartList = [];
    let {xUnit, yUnit, dataInfo} = data;

    let thisYUnit = yUnit ||"";

    let min = new Date().valueOf();
    let max = 0;
    for (let dataName in dataInfo) {
        let onceChartList = dataInfo[dataName];

        let dataList = [];
        let total = 0;

        onceChartList.forEach(item => {
            let {key, value, unit} = item;
            min = Math.min(value, min);
            max = Math.max(value, max);
            total += value;
            dataList.push({name:key, value, unit: unit || thisYUnit});
        });

        chartList.push({thisChartTitle:dataName, total, unit:thisYUnit, dataList});
    }
    
    let {maxNumber, minNumber, stepNumber} = unifiedMaxAndMinValueAndStep(max, min, stepCount);

    return {title, xUnit, yUnit:thisYUnit, yMinValue:minNumber, yMaxValue:maxNumber, yStepValue:stepNumber, chartList};
}

/**
 * getDoubleYBarChartOut  获取双y轴柱状图
 * @param title 数据标题 
 * @param data 数据体 格式：{xUnit:x轴单位, leftYUnit:左边y单位, rightYUnit:右边y单位 dataInfo:{"图表名称":{from:"left", subList:[{key:"数据key", value:"数据值", unit:"单位" }, {key:"数据key", value:"数据值", unit:"单位" } ]}    }   }
 * @returns {title:标题, xUnit:x轴单位, leftYUnit:左边单位, rightYUnit:右边单位, leftYMinValue:左边最小值, leftYMaxValue:左边最大值, leftYStepValue:左边间隔,
 * rightYMinValue:右边最小值, rightYMaxValue:右边最大值, rightYStepValue:右边间隔,
 * dataList:[{subTitle:数据名称, total:总数, unit:单位, subDataList:[{name:y轴名称, value:值, unit:单位}] }] }
 * 入参data里面的dataInfo中的unit可以为空 会读取yUnit 所以入参优先度 yUnit > unit  默认值都是空字符串
 */
export function getDoubleYBarChartOut(title, data, stepCountInfo?) {
    stepCountInfo = stepCountInfo || {left:5, right:5};
    let dataList = [];
    let {xUnit, leftYUnit, rightYUnit, dataInfo} = data;

    let thisLeftYUnit = leftYUnit || "";
    let thisRightYUnit = rightYUnit || "";

    let leftMin = new Date().valueOf();
    let leftMax = 0;
    let rightMin = new Date().valueOf();
    let rightMax = 0;

    for (let dataName in dataInfo) {
        let {subList, from} = dataInfo[dataName];

        let subDataList = [];
        let total = 0;

        let thisDataUnit = from == "left" ? thisLeftYUnit : thisRightYUnit;

        subList.forEach(item => {
            let {key, value, unit} = item;

            if (from == "left") {
                leftMin = Math.min(value, leftMin);
                leftMax = Math.max(value, leftMax);
            } else {
                rightMin = Math.min(value, rightMin);
                rightMax = Math.max(value, rightMax);
            }
            
            total += value;
            subDataList.push({name:key, value, unit:unit || thisDataUnit});
        });
        
        dataList.push({subTitle:dataName, total, unit:thisDataUnit, subDataList});
    }
    
    let leftInfo = unifiedMaxAndMinValueAndStep(leftMax, leftMin,stepCountInfo.left);
    let rightInfo = unifiedMaxAndMinValueAndStep(rightMax, rightMin,stepCountInfo.right);

    return {title, xUnit, leftYUnit:thisLeftYUnit, rightYUnit:thisRightYUnit, leftYMinValue:leftInfo.minNumber, leftYMaxValue:leftInfo.maxNumber, leftYStepValue:leftInfo.stepNumber,
    rightYMinValue:rightInfo.minNumber, rightYMaxValue:rightInfo.maxNumber, rightYStepValue:rightInfo.stepNumber, dataList}
}

/**
 * getTableOut  获取列表返回
 * @param title 数据标题
 * @param data 数据体 格式：{titleList:[], dataList:[{a,b,c},{a,b,c},{a,b,c}] }
 * @returns {title:数据标题, total:数据总条数, titleList:[表头...], valueList:[[a,b,c,d...],[a,b,c,d...]] }
 * 解出来的对象的key是需要有顺序的，所以进这里之前要把值a-z排好序，按显示要求排序，
 */
export function getTableOut(title, data) {
    
    let {titleList, dataList} = data;

    let valueList = [];

    dataList.forEach(info => {
        let subList = [];
        for (let key in info) {
            subList.push(info[key]);
        } 
        valueList.push(subList);
    });
    return { title, total:dataList.length, titleList, valueList };
}


/**
 * getKeyValueOut 获取键值的返回结果
 * @param title 数据标题
 * @param data 数据体 [{key:"", value:"", unit:""}]
 * @returns {title:数据标题, dataList:[], total:数据值总数, count:数据总条数 }
 */
export function getKeyValueOut(title, data) {
    let dataList = [];

    let total = 0;
    data.forEach(info => {
        let {key, value, unit} = info;
        let typeChangeValue;
        if (!isNaN(value)) {
            typeChangeValue = parseFloat(value); 
            total+= typeChangeValue;
        } else typeChangeValue = value;
        dataList.push({name:key, value:typeChangeValue, unit});
    });

    return {title, total, count:dataList.length, dataList};
}

/**
 * getObjectListOut 获取对象数组结果
 * @param title 数据标题
 * @param data 数据体 [{value:"", value:"", unit:""}]
 * @returns {title:数据标题, dataList:[{name:"", value:"", key1:"", key2:""}] }
 */
export function getObjectListOut(title, data) {
    //todo 没有特殊逻辑
    return {title, dataList:data};
}


/**
 * getRankOut 获取排名结果
 * @param title 数据标题
 * @param data 数据体 {unit, max, dataInfo:[{key, value, details}, {}, {}, {}] }
 * @returns  {title:数据标题, max, unit dataList:[{name, value, unit, rankNumber}] }
 */
export function getRankOut(title, data) {
    let {unit, max, dataInfo} = data;
    
    let dataList = [];
    dataInfo.forEach((info, index) => {
        let {key, value} = info;
        let rankNumber = index + 1;
        dataList.push({name:key, value, details:info.details, rankNumber});
    });


    return { title, unit, max, dataList };
}


/**
 * getRadarChartOut 获取雷达图
 * @param title 数据标题
 * @param data 数据体  [{key, value, max, unit}]
 * @returns {title:数据标题, dataList:[{name:"指标名称", max:"最大值", value:"当前值", unit:"单位"}]}
 */
export function getRadarChartOut(title, data) {
    let dataList = [];
    data.forEach(info => {
        dataList.push({
            name:info.key,
            value:info.value, 
            max:info.max,
            unit:info.unit
        });
    });
    return {title, dataList};
}

/**
 * getMapOut 地图数据
 * @param title 数据标题
 * @param data 数据体 [{name:数据名称, x:x坐标, y:坐标, coordinate:[经度, 纬度], unit:单位,  value:值, details:"补充"}]
 * @returns {title:数据标题, dataList:[{name:数据名称, x:x坐标, y:坐标, coordinate:[经度, 纬度], unit:单位,  value:值, details:"补充"} ]  }
 */
export function getMapOut(title, data) {
    //todo 无特殊逻辑
    return {title, dataList:data};
}

/**
 * getScatterFigureOutData  获取撒点图的返回结果
 * @param title 标题
 * @param data 数据 格式 [{x, y, name}, {x, y, name}, {x, y, name}, {x, y, name}]
 * @returns { title:标题, xMax:x轴最大值, xMin:x最小值, yMax:y最大值, yMin:y最小值, dataList:[{name:点的名称, value:[x坐标, y坐标]} ] };
 */
export function getScatterFigureOutData(title, data) {
    let dataList = [];
    let xMaxNumber = 0;
    let xMinNumber = new Date().valueOf();
    let yMaxNumber = 0;
    let yMinNumber = new Date().valueOf();

    data.forEach(item => {
        let { x, y, name } = item;
        let xCoordinateInfo = separateDataAndUint(x);
        let yCoordinateInfo = separateDataAndUint(y);

        const XNumber = xCoordinateInfo.dataNum;
        const YNumber = yCoordinateInfo.dataNum;

        yMaxNumber = Math.max(YNumber, yMaxNumber);
        yMinNumber = Math.min(YNumber, yMinNumber);
        xMaxNumber = Math.max(XNumber, xMaxNumber);
        xMinNumber = Math.min(XNumber, xMinNumber);

        let value = [XNumber, YNumber];
        dataList.push({ value, name:name || "" });

    });

    let xMaxMinInfo = unifiedMaxAndMinValueAndStep(xMaxNumber, xMinNumber);
    let yMaxMinInfo = unifiedMaxAndMinValueAndStep(yMaxNumber, yMinNumber);

    return { title, xMax:xMaxMinInfo.maxNumber, xMin:xMaxMinInfo.minNumber, yMax:yMaxMinInfo.maxNumber, yMin:yMaxMinInfo.minNumber, dataList };
}
