
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}

export function qyfwTableData() {
    
    let blockDataList = onceSheetBecomeOfblockData('yuyiServer.xlsx', '企业服务');

    let keyValueOrTitleList = ["企业基本情况","入孵时长分布","孵化企业行业领域占比","企业服务汇总数据","企业需求动态","企业变化情况","金融服务","在孵企业总营收","知识产权","知识产权饼图","企业资质分类"];//适配 饼图 键值以及需要多个key的
    let barChartList = ["变化趋势分析","企业人才","变化趋势","本月融资企业","本月融资金额"]; //适配 柱状图 折线图 
    let stringList = [];
    let decollatePlanarList =["企业需求动态详细","地图","金融服务企业","知识产权详情","企业资质分类_小巨人","企业资质分类_高新企业","企业资质分类_专精特新","企业资质分类_高企培育"];//适配 表格
    let titltListConfig = {};

    let result = packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;

        
}