import { DEGREE, OPERATIONALDATATYPE, TABLENAME } from "../../config/enum";
import { selectData, selectManyTableData } from "./operationalData";



export async function getQyszhx(eId) {
    let qyszhx = {
        企业基本情况:{dataList:[], titleList:['key', 'value']},
        企业基本数据:{dataList:[], titleList:['key', 'value']},
        企业标签:{dataList:[], titleList:['key', 'value']},
        知识产权:{dataList:[], titleList:['key', 'value']},
        企业员工画像:{dataList:[], titleList:['key', 'value']},
        企业汇总数据:{dataList:[], titleList:['key', 'value']},
        营收情况:{dataList:[], titleList:['key', 'value']},
        营收变化趋势:[],
        企业动态:{bodyList:[], headerList:[['企业照片', '获奖名称', '获奖时间', '颁奖单位', '奖项等级']]},
        服务需求:{dataList:[], titleList:['key', 'value']},
        活动变化趋势分析:[],
        服务记录_空间服务:{bodyList:[], headerList:[['服务名称', '服务时间', '服务内容']]},
        服务记录_工商服务:{bodyList:[], headerList:[['服务名称', '服务时间', '服务内容']]},
        服务记录_融资服务:{bodyList:[], headerList:[['服务名称', '服务时间', '服务内容']]},
        服务记录:{dataList:[], titleList:['key', 'value']},
    }

    let nowTime = new Date().valueOf();

    /**数据库查询 */
    let 企业基础信息 = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.企业基础信息表, {eId}, null);
    
    // let column = ["eId", "enterpriseName", "uscc", "", "", "", "", "", "", "", "", "", "", "", ""];
    let 孵化Column = ["fId", "eId", "startTime", "endTime", "state", "virtualCause", "virtualCauseDes", "moveOutType", "moveOutTrace", "moveOutCause", "moveOutTime", 
    "graduationTime", "jiShuHeTongJiaoYi"];

    let 企业孵化联查includeConf = {};
    企业孵化联查includeConf[TABLENAME.企业孵化信息] = {cloum:孵化Column, where:{}}
    let 企业孵化信息 = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {eId}, [], 企业孵化联查includeConf);

    let 资质Column = ["qId", "eId", "kxTime", "zjtxTime", "xjrTime", "xjrPyTime", "goPublicTime", "gaoXinJiShuTime", "goPublicSector"];
    let 企业资质联查includeConf = {};
    企业资质联查includeConf[TABLENAME.企业资质] = {cloum:资质Column, where:{}}
    let 企业资质信息 = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {eId}, [], 企业资质联查includeConf);
    
    let 专利Column = ["pId", "eId", "year", "alienPatent", "classIPatent", "secondClassPatent", "thirdPentent"];
    let 企业专利联查includeConf = {};
    企业专利联查includeConf[TABLENAME.企业专利表] = {cloum:专利Column, where:{}}
    let 企业专利信息 = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {eId}, [], 企业专利联查includeConf);
    
    let 创业团队Column = ["tId", "eId", "name", "sex", "birth", "degree", "graduationSchool", "talentType", "des"];
    let 创业团队联查includeConf = {};
    创业团队联查includeConf[TABLENAME.创业团队] = {cloum:创业团队Column, where:{}}
    let 创业团队信息 = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {eId}, [], 创业团队联查includeConf);

    //企业基本情况
    let qyjbqk = {
        企业介绍:企业基础信息.jianJie,
        企业图片:"企业照片占位图.png",
    };
    qyszhx.企业基本情况.dataList = getKeyValue(qyjbqk);

    //企业基本数据
    let qyjbsj = {
        注册时间:企业基础信息.logonTime,
        迁入时间:"",
        首次入孵时间:企业孵化信息[0].enterprise_fuhuas.startTime
    };
    qyszhx.企业基本数据.dataList = getKeyValue(qyjbsj);

    //企业标签
    let qybq = {

    }

    //知识产权
    let zscq = get知识产权(企业专利信息);
    qyszhx.知识产权.dataList = getKeyValue(zscq);

    //企业员工画像
    let qyyghx = get企业员工画像(创业团队信息);
    qyszhx.企业员工画像.dataList = getKeyValue(qyyghx);


    return qyszhx;
}


function get知识产权(data) {
    let zscq = {
        一级专利:0,
        二级专利:0,
        三级专利:0,
        海外专利:0,
    }

    data.forEach( info => {
        zscq.一级专利 += info.classIPatent;
        zscq.二级专利 += info.secondClassPatent
        zscq.三级专利 += info.thirdPentent;
        zscq.海外专利 += info.alienPatent;
    })

    return zscq;
}


async function get企业员工画像(data) {
    let qyyghx = {};

    for (let key in DEGREE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            if (!qyyghx[keyStr]) qyyghx[keyStr] = 0;
            let degree = DEGREE[key];
            data.forEach( info => {
                let {enterprise_teams} = info;
                enterprise_teams.forEach( team => {
                    if (degree == team.degree) {
                        qyyghx[keyStr] += 1;
                    }
                })
                
            })
        }
    }

    return qyyghx;
}






function getKeyValue(data) {
    let result = [];
    for (let key in data) {
        result.push({key, value:data[key]});
    }

    return result;
}


