/**
 * 企业服务
 */

import moment = require("moment");
import { FUHUASTATE, INDUSTRY, MOVEOUTTYPE, OPERATIONALDATATYPE, STATE, TABLENAME } from "../../config/enum";
import { selectData, selectManyTableData } from "./operationalData";


export async function getEnterprise() {
    let qyfw = {
        企业基本情况:{dataList:[], titleList:['key', 'value']}, //企业基本情况
        变化趋势分析:[], //变化趋势分析
        入孵时长分布:{dataList:[], titleList:['key', 'value']}, //入孵时长分布
        孵化企业行业领域占比:{dataList:[], titleList:['key', 'value']}, //孵化企业行业领域占比
        企业服务汇总数据:{dataList:[], titleList:['key', 'value']}, //企业服务汇总数据
        企业需求动态:{dataList:[], titleList:['key', 'value']}, //企业需求动态
        企业需求动态详细:{bodyList:[], headerList:[['企业名称', '类型', 'eId']]}, //企业需求动态详细
        企业变化情况:{dataList:[], titleList:['key', 'value']}, //企业变化情况
        企业变化情况变化趋势:[], //企业变化情况——变化趋势
        金融服务:{dataList:[], titleList:['key', 'value']}, //金融服务
        本月融资企业:[], //本月融资企业
        本月融资金额:[], //本月融资金额
        在孵企业总营收:{dataList:[], titleList:['key', 'value']}, //在孵企业总营收
        金融服务企业:{bodyList:[], headerList:[['企业名称', '融资金额', '融资时间']]}, //金融服务企业 todo
        知识产权:{dataList:[], titleList:['key', 'value']}, //知识产权
        知识产权饼图:{dataList:[], titleList:['key', 'value']}, //知识产权饼图
        知识产权详情:{bodyList:[], headerList:[['企业名称', '专利数量', '企业需求']]}, //知识产权详情
        企业资质分类:{dataList:[], titleList:['key', 'value']}, //企业资质分类
        企业资质分类_小巨人:{bodyList:[], headerList:[['企业名称', '资质类型']]}, //企业资质分类_小巨人
        企业资质分类_高新企业:{bodyList:[], headerList:[['企业名称', '资质类型']]}, //企业资质分类_高新企业
        企业资质分类_专精特新:{bodyList:[], headerList:[['企业名称', '资质类型']]}, //企业资质分类_专精特新
        企业资质分类_高企培育:{bodyList:[], headerList:[['企业名称', '资质类型']]}, //企业资质分类_高企培育
    }

    let nowTime = new Date().valueOf();
    let selectParam = {"endTime":{"%gt%":nowTime}};
    let zlColumn = ["eId", "area", "unitPrice", "isDeposit", "startTime", "endTime", "rentFreeStart", "rentFreeEnd", "roomNumber", 
    "rent", "notes", "leaseContract", "entryPlan", "businessLicense", "agreement"];
    /**在孵：获取租赁结束时间大于当前时间的租赁信息 */
    let zldbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.租赁信息, selectParam, zlColumn);

    let qyjbqk = {
        "孵化面积":0,
        "在孵企业":0,
        "毕业企业":0
    };
    zldbList.forEach( item => {
        qyjbqk.孵化面积 += parseInt(item.area);
    })

    let fhColumn = ["fId", "eId", "startTime", "endTime", "state", "virtualCause", "virtualCauseDes", "moveOutType", 
    "moveOutTrace", "moveOutCause", "moveOutTime", "graduationTime"];
    //获取所有企业孵化信息
    let fhdbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {}, fhColumn);
    //获取在孵企业
    let 在孵dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {"endTime":{"%gt%":nowTime}}, fhColumn);
    //获取毕业企业
    let 毕业dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业孵化信息, {"moveOutType":MOVEOUTTYPE.毕业迁出}, fhColumn);
    //获取所有企业孵化表联查企业信息表
    let 孵化企业includeConf = {};
    let 孵化企业Clumn = ["enterpriseName", "industry"];
    孵化企业includeConf[TABLENAME.企业基础信息表] = {cloum:孵化企业Clumn, where:{}}
    let 孵化企业dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业孵化信息, {}, fhColumn, 孵化企业includeConf);

    //企业基本信息
    qyjbqk.在孵企业 = 在孵dbList.length;
    // qyjbqk.毕业企业 = 毕业dbList.length;
    qyfw.企业基本情况.dataList = getKeyValue(qyjbqk);

    //变化趋势分析 //todo 需要日志表
    getBhqsfx(fhdbList);

    //入孵时长分布
    let rfscfb = getRfscfx(fhdbList);
    qyfw.入孵时长分布.dataList = getKeyValue(rfscfb);

    //孵化企业行业领域占比
    for (let key in INDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let industry = INDUSTRY[key];
            let count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.企业基础信息表, {industry}, null);
            qyfw.孵化企业行业领域占比.dataList.push({key:keyStr, value:count})
        }
    }
    
    //企业服务汇总数据`
    let qyfwhzsj = await getQyfwhzsj();
    qyfw.企业服务汇总数据.dataList = getKeyValue(qyfwhzsj);

    //企业需求动态
    let 入孵申请dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业基础信息表, {state:STATE.是}, null);
    let 企业服务Count = await selectData(OPERATIONALDATATYPE.查询数据量, TABLENAME.企业服务表, {}, null);
    let {qyxqdt, qyxqdtxx} = await getQyxqdt(入孵申请dbList, 企业服务Count);
    qyfw.企业需求动态.dataList = getKeyValue(qyxqdt);
    //企业需求动态详细 上面3中汇总数据类型的所有企业列表，由于毕业认证企业取不到数据，只汇总入孵申请和企业需求数的企业列表
    qyfw.企业需求动态详细.bodyList = qyxqdtxx;
    
    //企业变化情况
    let qybhqk = getQybhqk(在孵dbList);
    qyfw.企业变化情况.dataList = getKeyValue(qybhqk);

    //企业变化情况——变化趋势
    let qybhqkbhqs = getQybhqkbhqs(在孵dbList);
    qyfw.企业变化情况变化趋势 = qybhqkbhqs;

    let 企业融资dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业融资, {}, null);

    //金融服务
    let jrfw = getJrfw(在孵dbList, 企业融资dbList);
    qyfw.金融服务.dataList = getKeyValue(jrfw);

    //本月融资企业
    let byrzqy = await getByrzqy(企业融资dbList);
    qyfw.本月融资企业 = byrzqy.byrzqybhqs;

    //本月融资金额
    qyfw.本月融资金额 = byrzqy.byrzjebhqs;

    //在孵企业总营收
    let zfqyzys = getZfqyzys(在孵dbList);
    qyfw.在孵企业总营收.dataList = getKeyValue(zfqyzys);

    //金融服务企业
    let rzqylcColumn = ["rId", "eId", "financingAmount", "financingRounds", "fuHuaQiInvestment", "fuHuaQiInvestmentStyle", "fuHuaQiInvestmentAmount", 
    "investmentDate", "investmentInstitutionsName", "valuation"];
    let 融资企业联查includeConf = {};
    let 融资企业联查Clumn = ["enterpriseName"];
    融资企业联查includeConf[TABLENAME.企业基础信息表] = {cloum:融资企业联查Clumn, where:{}}
    let 融资企业联查dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业融资, {}, rzqylcColumn, 融资企业联查includeConf);
    let jrfwqy = getJrfwqy(融资企业联查dbList); //todo
    qyfw.金融服务企业.bodyList = jrfwqy;

    //知识产权
    let 企业专利dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业专利表, {}, null);
    let {zscq, zscqbt} = getZscq(企业专利dbList);
    qyfw.知识产权.dataList = getKeyValue(zscq);
    qyfw.知识产权饼图.dataList = getKeyValue(zscqbt);

    //知识产权详情 专利数据和服务数据没法保持一致，不知道要怎么样实现在一个表格展现
    let 专利Column = ["eId", "year", "alienPatent", "classIPatent", "secondClassPatent", "thirdPentent"];
    let 知识产权联查includeConf = {};
    知识产权联查includeConf[TABLENAME.企业专利表] = {cloum:专利Column, where:{}}
    知识产权联查includeConf[TABLENAME.企业服务表] = {cloum:["needContent"], where:{}}
    let 知识产权详情dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业基础信息表, {}, ["enterpriseName"], 知识产权联查includeConf);
    let zscqxq = await getZscqxq(知识产权详情dbList)

    //企业资质分类
    let 企业资质Column = ["qId", "eId", "kxTime", "zjtxTime", "xjrTime", "xjrPyTime", "goPublicTime", "gaoXinJiShuTime", "goPublicSector"];
    let 企业资质联查includeConf = {};
    企业资质联查includeConf[TABLENAME.企业基础信息表] = {cloum:["enterpriseName"], where:{}}
    let 企业资质dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业资质, {}, 企业资质Column, 融资企业联查includeConf);
    let qyzzfl = getQyzzfl();
    let qyzzfl_xjr = getQyzzfl();

    return qyfw;
}


/**
 * 变化趋势分析
 * @param data 
 */
function getBhqsfx(data) {
    let bhqsfx = {
        "在孵":[],
        "毕业":[]
    }

    //todo 变化趋势分析 需要日志表
    bhqsfx["在孵"] = [
        {key:"2019", value:4},
        {key:"2020", value:4},
    ];
    bhqsfx["毕业"] = [
        {key:"2019", value:4},
        {key:"2020", value:4},
    ];
    data.forEach( item => {
    })
}


/**
 * 入孵时长分布
 * @param data 
 */
function getRfscfx(data) {
    let rfscfx = {
        "即将到期":0, //3个月
        "1年以内":0,
        "1-2年":0,
        "2-3年":0,
        "3-4年":0
    };

    let nowTime = moment();
    data.forEach( item => {
        let parsedEndTime = moment(item.endTime); //获取入孵结束时间
        let monthDiff = parsedEndTime.diff(nowTime, 'months');
        if (monthDiff >= 0 && monthDiff < 3) rfscfx.即将到期 += 1;
        else if (monthDiff >=3 && monthDiff < 12) rfscfx["1年以内"] += 1;
        else if (monthDiff >=12 && monthDiff < 24) rfscfx["1-2年"] += 1;
        else if (monthDiff >=24 && monthDiff < 36) rfscfx["2-3年"] += 1;
        else if (monthDiff >=36 && monthDiff < 48) rfscfx["3-4年"] += 1;
    })

    return rfscfx;
}


/**
 * 企业服务汇总数据
 * @param data 
 */
async function getQyfwhzsj() {
    let qyfwhzsj = {
        "企业总营收额":0,
        "企业纳税":0,
        "融资企业":0,
        "企业专利":0
    };
    let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, {}, null);
    经营信息dbList.forEach( info => {
        qyfwhzsj.企业总营收额 += info.BI;
        qyfwhzsj.企业纳税 += info.TXP;
    })

    let 企业融资dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业融资, {}, null);
    企业融资dbList.forEach( info => {
        qyfwhzsj.融资企业 += info.financingAmount;
    })

    let 企业专利dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业专利表, {}, null);
    企业专利dbList.forEach( info => {
        qyfwhzsj.企业专利 += info.alienPatent;
        qyfwhzsj.企业专利 += info.classIPatent;
        qyfwhzsj.企业专利 += info.secondClassPatent;
        qyfwhzsj.企业专利 += info.thirdPentent;
    })

    return qyfwhzsj;
}


/**
 * 企业需求动态
 */
async function getQyxqdt(入孵申请dbList, 企业服务Count) {
    let qyxqdt = {
        入孵申请:0,
        毕业认证企业:0,
        企业需求数:0
    }
    qyxqdt.入孵申请 = 入孵申请dbList.length;
    qyxqdt.企业需求数 = 企业服务Count;

    let qyxqdtxx = [];
    入孵申请dbList.forEach( info => {
        qyxqdtxx.push([info.enterpriseName, "入孵申请", info.eId]);
    })
    //获取所有企业服务表联查企业信息表
    let qyfwColumn = ["esId", "eId", "needCategory", "needContent"];
    let 企业服务includeConf = {};
    企业服务includeConf[TABLENAME.企业基础信息表] = {cloum:["enterpriseName"], where:{}}
    let 企业服务dbList = await selectManyTableData(OPERATIONALDATATYPE.多表联查, TABLENAME.企业服务表, {}, qyfwColumn, 企业服务includeConf);
    企业服务dbList.forEach( info => {
        qyxqdtxx.push([info.enterprise.enterpriseName, "企业需求", info.enterprise.eId]);
    })

    return {qyxqdt, qyxqdtxx};
}


/**
 * 企业变化情况
 * @param data 
 */
function getQybhqk(data) {
    let qybhqk = {
        新增企业:0, //统计当前年份入孵企业
        迁出企业:0
    }

    let nowTime = moment();
    data.forEach( info => {
        let parsedStartTime = moment(info.startTime); //获取入孵开始时间
        // 检查日期字段的年份是否与当前年份相同
        if (parsedStartTime.isValid() && parsedStartTime.year() === nowTime.year()) {
            qybhqk.新增企业 += 1;
        }
    })

    return qybhqk;
}


/**
 * 企业变化情况——变化趋势
 */
function getQybhqkbhqs(data){
    let year = ["2019", "2020", "2021", "2022", "2023", "2024"];
    let hbqs = {
        "企业数":[]
    }
    for (let i = 0; i < year.length; i++) {
        let count = 0;
        data.forEach( info => {
            let startTimeYear = moment(info.startTime).year(); //获取入孵开始时间
            let thisYear = parseInt(year[i]);
            if (startTimeYear === thisYear) count += 1;
        })
        hbqs.企业数.push({key:year[i], value:count});
    }

    let qybhqkbhqs = getChart(hbqs);

    return qybhqkbhqs;
}


/**
 * 金融服务
 */
async function getJrfw(data, 企业融资dbList) {
    let jrfw = {
        本月融资企业:0,
        本月融资金额:0,
        在孵企业总营收:0
    }

    let nowTime = moment();
    企业融资dbList.forEach( info => {
        let parsedTime = moment(info.investmentDate); //获取融资时间
        if (parsedTime.isValid() && parsedTime.month() === nowTime.month()) {
            jrfw.本月融资企业 += 1;
            jrfw.本月融资金额 += info.financingAmount;
        }
    })

    for (let i = 0; i < data.length; i++) {
        //获取在孵企业经营数据
        let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, {eId:data[i].eId}, null);
        经营信息dbList.forEach( info => {
            jrfw.在孵企业总营收 += info.BI;
        })
    }

    return jrfw;
}


/**
 * 本月融资企业
 * @param data
 * @returns 
 */
async function getByrzqy(企业融资dbList){
    /**获取距离当前时间的前6个月 */
    let month = getMonthList();
    
    let byrzqy = {
        "融资企业":[]
    }
    let byrzje = {
        "融资金额":[]
    }
    for (let i = 0; i < month.length; i++) {
        let 企业count = 0;
        let 金额count = 0;
        企业融资dbList.forEach( info => {
            let parsedTime = moment(info.investmentDate).format("YYYY-MM"); //获取融资时间
            if (parsedTime === month[i]) {
                企业count += 1;
                金额count += info.financingAmount;
            }
        })
        byrzqy.融资企业.push({key:month[i], value:企业count});
        byrzje.融资金额.push({key:month[i], value:金额count});
    }

    let byrzqybhqs = getChart(byrzqy);
    let byrzjebhqs = getChart(byrzje);

    return {byrzqybhqs, byrzjebhqs};
}


/**
 * 在孵企业总营收
 */
async function getZfqyzys(data) {
    let zfqyzys = {
        "500万以下":0,
        "500万-1000万":0,
        "1000万-2000万":0,
        "2000万以上":0
    }

    for (let i = 0; i < data.length; i++) {
        //获取在孵企业经营数据
        let 经营信息dbList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.企业经营信息, {eId:data[i].eId}, null);
        经营信息dbList.forEach( info => { //BI（单位万元）
            if (info.BI < 500) zfqyzys["500万以下"] += 1;
            else if (info.BI >= 500 && info.BI < 1000) zfqyzys["500万-1000万"] += 1;
            else if (info.BI >= 1000 && info.BI < 2000) zfqyzys["1000万-2000万"] += 1;
            else zfqyzys["2000万以上"] += 1;
        })
    }

    return zfqyzys
}


/**
 * 金融服务企业
 * @param data 
 */
function getJrfwqy(data) {
    let jrfwqy = [];
    data.forEach( info => {
        let {financingAmount, enterprise, investmentDate} = info;
        let thisTime = moment(investmentDate).format("YYYY-MM-DD");
        jrfwqy.push([enterprise.enterpriseName, financingAmount, thisTime]);
    })

    return jrfwqy;
}


/**
 * 知识产权
 */
function getZscq(data) {
    let zscq = {
        一类专利:0,
        二类专利:0
    };

    let zscqbt = {
        海外:0,
        一类:0,
        二类:0,
        其他:0
    }

    data.forEach( info => {
        zscq.一类专利 += info.classIPatent;
        zscq.二类专利 += info.secondClassPatent

        zscqbt.海外 += info.alienPatent;
        zscqbt.一类 += info.classIPatent;
        zscqbt.二类 += info.secondClassPatent
        zscqbt.其他 += info.thirdPentent;
    })

    return {zscq, zscqbt};
}


/**
 * 知识产权详情
 */
function getZscqxq(data) {
    data.forEach( info => {

    })
}


/**
 * 企业资质分类
 */
function getQyzzfl() {
    let qyzzfl = {
        小巨人:0,
        高新企业:0,
        专精特精:0,
        高企培育:0,
    }



}



/**
 * 企业人才
 */
async function getQyrc() {
    let year = ["2019", "2020", "2021", "2022", "2023", "2024"];
    let qyrc = {
        "就业人数":[],
        "创业团队分布":[]
    }
    for (let i = 0; i < year.length; i++) {
        let dbData = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.参保记录, {annual:year[i]}, null);
        let count = 0;
        dbData.forEach( info => {
            let {zhuanKe, benKe, yanJiuSheng, boShi, qiTa} = info;
            count += zhuanKe;
            count += benKe;
            count += yanJiuSheng;
            count += boShi;
            count += qiTa;
        })
        qyrc["就业人数"].push({key:year[i], value:count})
    }

    return qyrc;
}


function getKeyValue(data) {
    let result = [];
    for (let key in data) {
        result.push({key, value:data[key]});
    }

    return result;
}

function getChart(data) {
    let result = [];
    for(let key in data) {
        result.push({name:key, data:data[key]})
    }

    return result;
}


function getMonthList() {
    // 获取当前时间
    const currentTime = moment();
    
    // 获取6个月前的时间
    const sixMonthsAgo = currentTime.clone().subtract(6, 'months');
    
    // 创建一个数组来存储每个月份的第一天
    const monthsArray = [];
    
    // 使用moment的range函数（如果可用）或者手动循环来遍历月份
    // 注意：moment.js的官方库中并没有直接的range函数用于月份遍历，
    // 但我们可以使用.month()和.date(1)结合循环来实现。
    
    // 由于moment没有内置的range函数用于月份，我们需要手动处理
    let currentMonth = sixMonthsAgo.clone();
    while (currentMonth.isBefore(currentTime) || currentMonth.isSame(currentTime, 'month')) {
        // 获取当前循环月份的第一天
        const firstDayOfMonth = currentMonth.clone().date(1);
        
        // 将月份添加到数组中
        monthsArray.push(moment(firstDayOfMonth.clone().toDate()).format("YYYY-MM")); // 如果你需要Date对象
        // monthsArray.push(firstDayOfMonth.format('YYYY-MM-DD')); // 如果你需要格式化字符串
        
        // 移动到下一个月
        currentMonth.add(1, 'months');
    }

    return monthsArray;
}




